/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import net.solarnetwork.domain.BaseId;
import net.solarnetwork.domain.datum.ObjectDatumKind;

public class DatumId
extends BaseId
implements Serializable,
Cloneable,
Comparable<DatumId> {
    private static final long serialVersionUID = 6891814538805568843L;
    private final ObjectDatumKind kind;
    private final Long objectId;
    private final String sourceId;
    private final Instant timestamp;

    public static DatumId nodeId(Long nodeId, String sourceId, Instant timestamp) {
        return new DatumId(ObjectDatumKind.Node, nodeId, sourceId, timestamp);
    }

    public static DatumId locationId(Long locationId, String sourceId, Instant timestamp) {
        return new DatumId(ObjectDatumKind.Location, locationId, sourceId, timestamp);
    }

    public DatumId(ObjectDatumKind kind, Long objectId, String sourceId, Instant timestamp) {
        this.kind = kind;
        this.objectId = objectId;
        this.sourceId = sourceId;
        this.timestamp = timestamp;
    }

    @Override
    public DatumId clone() {
        return (DatumId)super.clone();
    }

    @Override
    protected void populateIdValue(StringBuilder buf) {
        buf.append("k=");
        if (this.kind != null) {
            buf.append(this.kind.getKey());
        }
        buf.append("o=");
        if (this.objectId != null) {
            buf.append(this.objectId);
        }
        buf.append("s=");
        if (this.sourceId != null) {
            buf.append(this.sourceId);
        }
        buf.append(";t=");
        if (this.timestamp != null) {
            buf.append(this.timestamp.getEpochSecond()).append('.').append(this.timestamp.getNano());
        }
    }

    @Override
    protected void populateStringValue(StringBuilder buf) {
        if (this.kind != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("kind=");
            buf.append((Object)this.kind);
        }
        if (this.objectId != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("objectId=");
            buf.append(this.objectId);
        }
        if (this.sourceId != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("sourceId=");
            buf.append(this.sourceId);
        }
        if (this.timestamp != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("timestamp=");
            buf.append(this.timestamp);
        }
    }

    @Override
    public int compareTo(DatumId o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return -1;
        }
        int result = 0;
        if (this.kind != o.kind) {
            if (this.kind == null) {
                return 1;
            }
            if (o.kind == null) {
                return -1;
            }
            result = this.kind.compareTo(o.kind);
            if (result != 0) {
                return result;
            }
        }
        if (this.objectId != o.objectId) {
            if (this.objectId == null) {
                return 1;
            }
            if (o.objectId == null) {
                return -1;
            }
            result = this.objectId.compareTo(o.objectId);
            if (result != 0) {
                return result;
            }
        }
        if (this.sourceId != o.sourceId) {
            if (this.sourceId == null) {
                return 1;
            }
            if (o.sourceId == null) {
                return -1;
            }
            result = this.sourceId.compareTo(o.sourceId);
            if (result != 0) {
                return result;
            }
        }
        if (this.timestamp == o.timestamp) {
            return 0;
        }
        if (this.timestamp == null) {
            return 1;
        }
        if (o.timestamp == null) {
            return -1;
        }
        return this.timestamp.compareTo(o.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.objectId, this.sourceId, this.timestamp});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DatumId)) {
            return false;
        }
        DatumId other = (DatumId)obj;
        return Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.objectId, other.objectId) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.timestamp, other.timestamp);
    }

    public ObjectDatumKind getKind() {
        return this.kind;
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }
}

