/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collection;
import net.solarnetwork.util.NumberUtils;
import net.solarnetwork.util.StringUtils;

public interface DatumMathFunctions {
    default public BigInteger and(Number n, Number mask) {
        BigInteger integer = this.integer(n);
        BigInteger m = this.integer(mask);
        return integer != null && m != null ? integer.and(m) : integer;
    }

    default public BigInteger not(Number n) {
        BigInteger integer = this.integer(n);
        return integer != null ? integer.not() : integer;
    }

    default public BigInteger andNot(Number n, Number mask) {
        BigInteger integer = this.integer(n);
        BigInteger m = this.integer(mask);
        return integer != null && m != null ? integer.andNot(m) : integer;
    }

    default public BigInteger or(Number n, Number mask) {
        BigInteger integer = this.integer(n);
        BigInteger m = this.integer(mask);
        return integer != null && m != null ? integer.or(m) : integer;
    }

    default public BigInteger xor(Number n, Number mask) {
        BigInteger integer = this.integer(n);
        BigInteger m = this.integer(mask);
        return integer != null && m != null ? integer.xor(m) : integer;
    }

    default public BigInteger shiftRight(Number n, Number count) {
        BigInteger integer = this.integer(n);
        return integer != null && count != null ? integer.shiftRight(count.intValue()) : integer;
    }

    default public BigInteger shiftLeft(Number n, Number count) {
        BigInteger integer = this.integer(n);
        return integer != null && count != null ? integer.shiftLeft(count.intValue()) : integer;
    }

    default public boolean testBit(Number n, Number bit) {
        BigInteger integer = this.integer(n);
        return integer != null && bit != null ? integer.testBit(bit.intValue()) : false;
    }

    default public BigDecimal decimal(Object value) {
        if (value == null) {
            return null;
        }
        Number n = null;
        n = value instanceof Number ? (Number)((Number)value) : (Number)StringUtils.numberValue(value.toString());
        return NumberUtils.bigDecimalForNumber(n);
    }

    default public BigInteger integer(Object value) {
        if (value == null) {
            return null;
        }
        Number n = null;
        n = value instanceof Number ? (Number)((Number)value) : (Number)StringUtils.numberValue(value.toString());
        return NumberUtils.bigIntegerForNumber(n);
    }

    default public Number min(Number n1, Number n2) {
        return NumberUtils.min(n1, n2);
    }

    default public Number max(Number n1, Number n2) {
        return NumberUtils.max(n1, n2);
    }

    default public Number ceil(Number n) {
        return NumberUtils.ceil(n, BigDecimal.ONE);
    }

    default public Number ceil(Number n, Number significance) {
        return NumberUtils.ceil(n, significance);
    }

    default public Number floor(Number n) {
        return NumberUtils.floor(n, BigDecimal.ONE);
    }

    default public Number floor(Number n, Number significance) {
        return NumberUtils.floor(n, significance);
    }

    default public Number up(Number n) {
        return NumberUtils.roundUp(n, 0);
    }

    default public Number up(Number n, Number significance) {
        return NumberUtils.up(n, significance);
    }

    default public Number down(Number n) {
        return NumberUtils.roundDown(n, 0);
    }

    default public Number down(Number n, Number significance) {
        return NumberUtils.down(n, significance);
    }

    default public Number mround(Number n, Number significance) {
        return NumberUtils.mround(n, significance);
    }

    default public Number round(Number n) {
        return NumberUtils.round(n, 0);
    }

    default public Number round(Number n, Number digits) {
        return NumberUtils.round(n, digits);
    }

    default public Number roundUp(Number n, Number digits) {
        return NumberUtils.roundUp(n, digits);
    }

    default public Number roundDown(Number n, Number digits) {
        return NumberUtils.roundDown(n, digits);
    }

    default public Number narrow(Number n, Number digits) {
        return NumberUtils.narrow(n, digits.intValue());
    }

    default public Number narrow8(Number n) {
        return NumberUtils.narrow(n, 0);
    }

    default public Number narrow16(Number n) {
        return NumberUtils.narrow(n, 1);
    }

    default public Number narrow32(Number n) {
        return NumberUtils.narrow(n, 2);
    }

    default public Number narrow64(Number n) {
        return NumberUtils.narrow(n, 3);
    }

    default public Number sum(Collection<? extends Number> set) {
        BigDecimal result = null;
        if (set != null) {
            result = BigDecimal.ZERO;
            for (Number number : set) {
                if (number == null) continue;
                result = result.add(NumberUtils.bigDecimalForNumber(number));
            }
        }
        return result;
    }

    default public Number avg(Collection<? extends Number> set) {
        BigDecimal sum = (BigDecimal)this.sum(set);
        if (sum == null) {
            return null;
        }
        if (set.size() == 1) {
            return sum;
        }
        int nonNullCount = 0;
        for (Number number : set) {
            if (number == null) continue;
            ++nonNullCount;
        }
        BigDecimal count = new BigDecimal(nonNullCount);
        try {
            return sum.divide(count);
        }
        catch (ArithmeticException arithmeticException) {
            return sum.divide(count, 12, RoundingMode.HALF_UP);
        }
    }

    default public Number max(Collection<? extends Number> set) {
        if (set == null) {
            return null;
        }
        BigDecimal max = null;
        for (Number number : set) {
            BigDecimal d = this.decimal(number);
            if (d == null || max != null && d.compareTo(max) <= 0) continue;
            max = d;
        }
        return max;
    }

    default public Number min(Collection<? extends Number> set) {
        if (set == null) {
            return null;
        }
        BigDecimal min = null;
        for (Number number : set) {
            BigDecimal d = this.decimal(number);
            if (d == null || min != null && d.compareTo(min) >= 0) continue;
            min = d;
        }
        return min;
    }
}

