/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.domain.SerializeIgnore;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.DatumSupport;
import net.solarnetwork.domain.datum.MutableDatumSamplesOperations;

@JsonPropertyOrder(value={"i", "a", "s", "t"})
public class DatumSamples
extends DatumSupport
implements MutableDatumSamplesOperations,
Serializable {
    private static final long serialVersionUID = 3704506858283891128L;
    private Map<String, Number> instantaneous;
    private Map<String, Number> accumulating;
    private Map<String, Object> status;

    public DatumSamples() {
    }

    public DatumSamples(Map<String, Number> instantaneous, Map<String, Number> accumulating, Map<String, Object> status) {
        this.instantaneous = instantaneous;
        this.accumulating = accumulating;
        this.status = status;
    }

    public DatumSamples(DatumSamplesOperations other) {
        super(other);
        if (other != null) {
            Map<String, ?> o = other.getSampleData(DatumSamplesType.Instantaneous);
            this.instantaneous = o != null ? new LinkedHashMap(o) : null;
            o = other.getSampleData(DatumSamplesType.Accumulating);
            this.accumulating = o != null ? new LinkedHashMap(o) : null;
            o = other.getSampleData(DatumSamplesType.Status);
            this.status = o != null ? new LinkedHashMap(o) : null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        if (this.instantaneous != null) {
            builder.append("i=");
            builder.append(this.instantaneous);
            if (this.accumulating != null || this.status != null || this.getTags() != null) {
                builder.append(", ");
            }
        }
        if (this.accumulating != null) {
            builder.append("a=");
            builder.append(this.accumulating);
            if (this.status != null || this.getTags() != null) {
                builder.append(", ");
            }
        }
        if (this.status != null) {
            builder.append("s=");
            builder.append(this.status);
            if (this.getTags() != null) {
                builder.append(", ");
            }
        }
        if (this.getTags() != null) {
            builder.append("t=");
            builder.append(this.getTags());
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this.accumulating = null;
        this.instantaneous = null;
        this.status = null;
    }

    @JsonIgnore
    @SerializeIgnore
    public Map<String, ?> getSampleData() {
        if (this.instantaneous == null && this.accumulating == null && this.status == null) {
            return null;
        }
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>(4);
        if (this.instantaneous != null) {
            results.putAll(this.instantaneous);
        }
        if (this.accumulating != null) {
            results.putAll(this.accumulating);
        }
        if (this.status != null) {
            results.putAll(this.status);
        }
        if (this.getTags() != null) {
            results.put("tags", this.getTags().toArray());
        }
        return results;
    }

    @Override
    @JsonIgnore
    @SerializeIgnore
    public boolean isEmpty() {
        if (this.instantaneous != null && !this.instantaneous.isEmpty()) {
            return false;
        }
        if (this.accumulating != null && !this.accumulating.isEmpty()) {
            return false;
        }
        if (this.status != null && !this.status.isEmpty()) {
            return false;
        }
        return this.getTags() == null || this.getTags().isEmpty();
    }

    @Override
    public Map<String, ?> getSampleData(DatumSamplesType type) {
        Map<String, Object> data;
        switch (type) {
            case Instantaneous: {
                data = this.instantaneous;
                break;
            }
            case Accumulating: {
                data = this.accumulating;
                break;
            }
            case Status: {
                data = this.status;
                break;
            }
            default: {
                throw new IllegalArgumentException("Sample type [" + (Object)((Object)type) + "] not supported");
            }
        }
        return data;
    }

    @Override
    public void setSampleData(DatumSamplesType type, Map<String, ?> data) {
        switch (type) {
            case Instantaneous: {
                this.setInstantaneous(data);
                break;
            }
            case Accumulating: {
                this.setAccumulating(data);
                break;
            }
            case Status: {
                this.setStatus(data);
                break;
            }
            case Tag: {
                this.setTags(data.keySet());
                break;
            }
            default: {
                throw new IllegalArgumentException("Sample type [" + (Object)((Object)type) + "] not supported");
            }
        }
    }

    @Override
    public Integer getSampleInteger(DatumSamplesType type, String key) {
        return this.getMapInteger(key, this.getSampleData(type));
    }

    @Override
    public Long getSampleLong(DatumSamplesType type, String key) {
        return this.getMapLong(key, this.getSampleData(type));
    }

    @Override
    public Float getSampleFloat(DatumSamplesType type, String key) {
        return this.getMapFloat(key, this.getSampleData(type));
    }

    @Override
    public Double getSampleDouble(DatumSamplesType type, String key) {
        return this.getMapDouble(key, this.getSampleData(type));
    }

    @Override
    public BigDecimal getSampleBigDecimal(DatumSamplesType type, String key) {
        return this.getMapBigDecimal(key, this.getSampleData(type));
    }

    @Override
    public String getSampleString(DatumSamplesType type, String key) {
        if (type == DatumSamplesType.Tag) {
            Set<String> tags = this.getTags();
            return tags != null && tags.contains(key) ? key : null;
        }
        return this.getMapString(key, this.getSampleData(type));
    }

    @Override
    public <V> V getSampleValue(DatumSamplesType type, String key) {
        if (type == DatumSamplesType.Tag) {
            Set<String> tags = this.getTags();
            return (V)(tags != null && tags.contains(key) ? key : null);
        }
        Map<String, ?> m = this.getSampleData(type);
        return m != null ? (V)m.get(key) : null;
    }

    @Override
    public <V> V findSampleValue(String key) {
        V v = this.getSampleValue(DatumSamplesType.Instantaneous, key);
        if (v != null) {
            return v;
        }
        v = this.getSampleValue(DatumSamplesType.Accumulating, key);
        if (v != null) {
            return v;
        }
        return this.getSampleValue(DatumSamplesType.Status, key);
    }

    @Override
    public boolean hasSampleValue(String key) {
        Object o = this.findSampleValue(key);
        return o != null;
    }

    @Override
    public void putSampleValue(DatumSamplesType type, String key, Object value) {
        if (type == DatumSamplesType.Tag) {
            if (value == null) {
                this.removeTag(key);
            } else {
                if (!key.equals(value)) {
                    this.removeTag(key);
                }
                this.addTag(value.toString());
            }
            return;
        }
        if (type != DatumSamplesType.Status && value != null && !(value instanceof Number)) {
            return;
        }
        Map<String, ?> m = this.getSampleData(type);
        if (m == null) {
            if (value == null) {
                return;
            }
            m = new LinkedHashMap(4);
            this.setSampleData(type, m);
        }
        if (value == null) {
            m.remove(key);
        } else {
            m.put(key, value);
        }
    }

    @Override
    public boolean hasSampleValue(DatumSamplesType type, String key) {
        if (type == DatumSamplesType.Tag) {
            return this.hasTag(key);
        }
        Map<String, ?> data = this.getSampleData(type);
        return data != null ? data.containsKey(key) : false;
    }

    public void putInstantaneousSampleValue(String key, Number n) {
        Map<String, Number> m = this.instantaneous;
        if (m == null) {
            if (n == null) {
                return;
            }
            this.instantaneous = m = new LinkedHashMap<String, Number>(4);
        }
        if (n == null) {
            m.remove(key);
        } else {
            m.put(key, n);
        }
    }

    public void putAccumulatingSampleValue(String key, Number n) {
        Map<String, Number> m = this.accumulating;
        if (m == null) {
            if (n == null) {
                return;
            }
            this.accumulating = m = new LinkedHashMap<String, Number>(4);
        }
        if (n == null) {
            m.remove(key);
        } else {
            m.put(key, n);
        }
    }

    public void putStatusSampleValue(String key, Object value) {
        Map<String, Object> m = this.status;
        if (m == null) {
            if (value == null) {
                return;
            }
            this.status = m = new LinkedHashMap<String, Object>(4);
        }
        if (value == null) {
            m.remove(key);
        } else {
            m.put(key, value);
        }
    }

    public Integer getInstantaneousSampleInteger(String key) {
        return this.getMapInteger(key, this.instantaneous);
    }

    public Long getInstantaneousSampleLong(String key) {
        return this.getMapLong(key, this.instantaneous);
    }

    public Float getInstantaneousSampleFloat(String key) {
        return this.getMapFloat(key, this.instantaneous);
    }

    public Double getInstantaneousSampleDouble(String key) {
        return this.getMapDouble(key, this.instantaneous);
    }

    public BigDecimal getInstantaneousSampleBigDecimal(String key) {
        return this.getMapBigDecimal(key, this.instantaneous);
    }

    public Integer getAccumulatingSampleInteger(String key) {
        return this.getMapInteger(key, this.accumulating);
    }

    public Long getAccumulatingSampleLong(String key) {
        return this.getMapLong(key, this.accumulating);
    }

    public Float getAccumulatingSampleFloat(String key) {
        return this.getMapFloat(key, this.accumulating);
    }

    public Double getAccumulatingSampleDouble(String key) {
        return this.getMapDouble(key, this.accumulating);
    }

    public BigDecimal getAccumulatingSampleBigDecimal(String key) {
        return this.getMapBigDecimal(key, this.accumulating);
    }

    public Integer getStatusSampleInteger(String key) {
        return this.getMapInteger(key, this.status);
    }

    public Long getStatusSampleLong(String key) {
        return this.getMapLong(key, this.status);
    }

    public Float getStatusSampleFloat(String key) {
        return this.getMapFloat(key, this.status);
    }

    public Double getStatusSampleDouble(String key) {
        return this.getMapDouble(key, this.status);
    }

    public BigDecimal getStatusSampleBigDecimal(String key) {
        return this.getMapBigDecimal(key, this.status);
    }

    public String getStatusSampleString(String key) {
        return this.getMapString(key, this.status);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accumulating == null ? 0 : this.accumulating.hashCode());
        result = 31 * result + (this.instantaneous == null ? 0 : this.instantaneous.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatumSamples other = (DatumSamples)obj;
        if (this.accumulating == null ? other.accumulating != null : !this.accumulating.equals(other.accumulating)) {
            return false;
        }
        if (this.instantaneous == null ? other.instantaneous != null : !this.instantaneous.equals(other.instantaneous)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        return !(this.getTags() == null ? other.getTags() != null : !this.getTags().equals(other.getTags()));
    }

    public Map<String, Number> getI() {
        return this.getInstantaneous();
    }

    public void setI(Map<String, Number> map) {
        this.setInstantaneous(map);
    }

    public Map<String, Number> getA() {
        return this.getAccumulating();
    }

    public void setA(Map<String, Number> map) {
        this.setAccumulating(map);
    }

    public Map<String, Object> getS() {
        return this.getStatus();
    }

    public void setS(Map<String, Object> map) {
        this.setStatus(map);
    }

    @JsonIgnore
    @SerializeIgnore
    public Map<String, Number> getInstantaneous() {
        return this.instantaneous;
    }

    public void setInstantaneous(Map<String, Number> instantaneous) {
        this.instantaneous = instantaneous;
    }

    @JsonIgnore
    @SerializeIgnore
    public Map<String, Number> getAccumulating() {
        return this.accumulating;
    }

    public void setAccumulating(Map<String, Number> accumulating) {
        this.accumulating = accumulating;
    }

    @JsonIgnore
    @SerializeIgnore
    public Map<String, Object> getStatus() {
        return this.status;
    }

    public void setStatus(Map<String, Object> status) {
        this.status = status;
    }
}

