/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumExpressionRoot;
import net.solarnetwork.domain.datum.DatumMathFunctions;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.domain.datum.DatumSamplesType;

public class DatumSamplesExpressionRoot
extends AbstractMap<String, Object>
implements DatumExpressionRoot,
DatumMathFunctions {
    private final Datum datum;
    private final DatumSamplesOperations datumOps;
    private final DatumSamplesOperations sample;
    private final Map<String, ?> parameters;
    private static final DatumSamplesType[] TYPES = new DatumSamplesType[]{DatumSamplesType.Instantaneous, DatumSamplesType.Accumulating, DatumSamplesType.Status};
    private static final DatumSamplesType[] NUMBER_TYPES = new DatumSamplesType[]{DatumSamplesType.Instantaneous, DatumSamplesType.Accumulating};

    public DatumSamplesExpressionRoot(Datum datum, DatumSamplesOperations sample, Map<String, ?> parameters) {
        this.datum = datum;
        this.datumOps = datum != null ? datum.asSampleOperations() : null;
        this.sample = sample;
        this.parameters = parameters;
    }

    @Override
    public Datum getDatum() {
        return this.datum;
    }

    public DatumSamplesOperations getSamples() {
        return this.sample;
    }

    public Map<String, ?> getParameters() {
        return this.parameters;
    }

    @Override
    public Map<String, ?> getData() {
        return this;
    }

    @Override
    public Map<String, ?> getProps() {
        return this;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean has(Object key) {
        return this.get(key) != null;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        String k = key.toString();
        Object o = null;
        if (this.parameters != null && (o = this.parameters.get(key)) != null) {
            return o;
        }
        if (this.sample != null && (o = this.sample.findSampleValue(k)) != null) {
            return o;
        }
        if (this.datumOps != null && (o = this.datumOps.findSampleValue(k)) != null) {
            return o;
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new EntrySet();
    }

    private static <T> void populateMap(Map<String, T> dest, DatumSamplesOperations ops, DatumSamplesType[] types, Pattern pat) {
        for (DatumSamplesType type : types) {
            Map<String, ?> data = ops.getSampleData(type);
            if (data == null) continue;
            for (Map.Entry<String, ?> e : data.entrySet()) {
                if (pat != null && !pat.matcher(e.getKey()).find()) continue;
                dest.put(e.getKey(), e.getValue());
            }
        }
    }

    public final Collection<? extends Number> group(String pattern) {
        Pattern pat = Pattern.compile(pattern, 2);
        LinkedHashMap<String, Number> values = new LinkedHashMap<String, Number>(8);
        if (this.datumOps != null) {
            DatumSamplesExpressionRoot.populateMap(values, this.datumOps, NUMBER_TYPES, pat);
        }
        if (this.sample != null) {
            DatumSamplesExpressionRoot.populateMap(values, this.sample, NUMBER_TYPES, pat);
        }
        if (this.parameters != null) {
            for (Map.Entry<String, ?> e : this.parameters.entrySet()) {
                if (!pat.matcher(e.getKey()).find() || !(e.getValue() instanceof Number)) continue;
                values.put(e.getKey(), (Number)e.getValue());
            }
        }
        return values.values();
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<String, Object>>
    implements Set<Map.Entry<String, Object>> {
        private final Map<String, Object> delegate = new LinkedHashMap<String, Object>();

        private EntrySet() {
            Map<String, ?> data;
            if (DatumSamplesExpressionRoot.this.datumOps != null) {
                for (DatumSamplesType type : TYPES) {
                    data = DatumSamplesExpressionRoot.this.datumOps.getSampleData(type);
                    if (data == null) continue;
                    this.delegate.putAll(data);
                }
            }
            if (DatumSamplesExpressionRoot.this.sample != null) {
                for (DatumSamplesType type : TYPES) {
                    data = DatumSamplesExpressionRoot.this.sample.getSampleData(type);
                    if (data == null) continue;
                    this.delegate.putAll(data);
                }
            }
            if (DatumSamplesExpressionRoot.this.parameters != null) {
                this.delegate.putAll(DatumSamplesExpressionRoot.this.parameters);
            }
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return this.delegate.entrySet().iterator();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

