/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.domain.Differentiable;
import net.solarnetwork.domain.datum.DatumSamplesType;

public interface DatumSamplesOperations
extends Differentiable<DatumSamplesOperations> {
    public Map<String, ?> getSampleData(DatumSamplesType var1);

    public Integer getSampleInteger(DatumSamplesType var1, String var2);

    public Long getSampleLong(DatumSamplesType var1, String var2);

    public Float getSampleFloat(DatumSamplesType var1, String var2);

    public Double getSampleDouble(DatumSamplesType var1, String var2);

    public BigDecimal getSampleBigDecimal(DatumSamplesType var1, String var2);

    public String getSampleString(DatumSamplesType var1, String var2);

    public <V> V getSampleValue(DatumSamplesType var1, String var2);

    public boolean hasSampleValue(DatumSamplesType var1, String var2);

    public <V> V findSampleValue(String var1);

    public boolean hasSampleValue(String var1);

    public Set<String> getTags();

    default public boolean hasTag(String tag) {
        Set<String> tags = this.getTags();
        return tags != null && tags.contains(tag);
    }

    default public boolean isEmpty() {
        for (DatumSamplesType t : new DatumSamplesType[]{DatumSamplesType.Accumulating, DatumSamplesType.Instantaneous, DatumSamplesType.Status}) {
            Map<String, ?> d = this.getSampleData(t);
            if (d == null || d.isEmpty()) continue;
            return false;
        }
        Set<String> tags = this.getTags();
        return tags == null || tags.isEmpty();
    }

    @Override
    default public boolean differsFrom(DatumSamplesOperations other) {
        if (other == null) {
            return true;
        }
        if (this == other) {
            return false;
        }
        for (DatumSamplesType t : new DatumSamplesType[]{DatumSamplesType.Accumulating, DatumSamplesType.Instantaneous, DatumSamplesType.Status}) {
            Map<String, ?> d1 = this.getSampleData(t);
            Map<String, ?> d2 = other.getSampleData(t);
            if (!(d1 == null ? d2 != null : !d1.equals(d2))) continue;
            return true;
        }
        return this.getTags() == null ? other.getTags() != null : !this.getTags().equals(other.getTags());
    }
}

