/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.math.BigDecimal;
import java.time.LocalTime;
import net.solarnetwork.domain.datum.AtmosphericDatum;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.util.DateUtils;

public interface DayDatum
extends AtmosphericDatum {
    public static final String BRIEF_OVERVIEW_KEY = "brief";
    public static final String SUNRISE_KEY = "sunrise";
    public static final String SUNSET_KEY = "sunset";
    public static final String MOONRISE_KEY = "moonrise";
    public static final String MOONSET_KEY = "moonset";
    public static final String TEMPERATURE_MAXIMUM_KEY = "tempMax";
    public static final String TEMPERATURE_MINIMUM_KEY = "tempMin";

    default public String getBriefOverview() {
        return this.asSampleOperations().getSampleString(DatumSamplesType.Status, BRIEF_OVERVIEW_KEY);
    }

    default public LocalTime getSunriseTime() {
        String time = this.asSampleOperations().getSampleString(DatumSamplesType.Status, SUNRISE_KEY);
        if (time == null) {
            return null;
        }
        return DateUtils.parseLocalTime(time);
    }

    default public LocalTime getSunsetTime() {
        String time = this.asSampleOperations().getSampleString(DatumSamplesType.Status, SUNSET_KEY);
        if (time == null) {
            return null;
        }
        return DateUtils.parseLocalTime(time);
    }

    default public LocalTime getMoonriseTime() {
        String time = this.asSampleOperations().getSampleString(DatumSamplesType.Status, MOONRISE_KEY);
        if (time == null) {
            return null;
        }
        return DateUtils.parseLocalTime(time);
    }

    default public LocalTime getMoonsetTime() {
        String time = this.asSampleOperations().getSampleString(DatumSamplesType.Status, MOONSET_KEY);
        if (time == null) {
            return null;
        }
        return DateUtils.parseLocalTime(time);
    }

    default public BigDecimal getTemperatureMinimum() {
        return this.asSampleOperations().getSampleBigDecimal(DatumSamplesType.Instantaneous, TEMPERATURE_MINIMUM_KEY);
    }

    default public BigDecimal getTemperatureMaximum() {
        return this.asSampleOperations().getSampleBigDecimal(DatumSamplesType.Instantaneous, TEMPERATURE_MAXIMUM_KEY);
    }
}

