/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumSamplesType;

public interface EnergyDatum
extends Datum {
    public static final String WATT_HOUR_READING_KEY = "wattHours";
    public static final String WATTS_KEY = "watts";
    public static final String TAG_CONSUMPTION = "consumption";
    public static final String TAG_GENERATION = "power";

    default public Long getWattHourReading() {
        return this.asSampleOperations().getSampleLong(DatumSamplesType.Accumulating, WATT_HOUR_READING_KEY);
    }

    default public Long getReverseWattHourReading() {
        return this.asSampleOperations().getSampleLong(DatumSamplesType.Accumulating, "wattHoursReverse");
    }

    default public Integer getWatts() {
        return this.asSampleOperations().getSampleInteger(DatumSamplesType.Instantaneous, WATTS_KEY);
    }

    default public boolean isConsumption() {
        return this.asSampleOperations().hasTag(TAG_CONSUMPTION);
    }

    default public boolean isGeneration() {
        return this.asSampleOperations().hasTag(TAG_GENERATION);
    }
}

