/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumSamplesType;

public interface EnergyStorageDatum
extends Datum {
    public static final String STATE_OF_CHARGE_PERCENTAGE_KEY = "soc";
    @Deprecated
    public static final String PERCENTAGE_KEY = "percent";
    public static final String STATE_OF_HEALTH_PERCENTAGE_KEY = "soh";
    public static final String AVAILABLE_WATT_HOURS_KEY = "availWattHours";
    public static final String CAPACITY_WATT_HOURS_KEY = "capacityWattHours";

    default public Float getAvailableEnergyPercentage() {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, STATE_OF_CHARGE_PERCENTAGE_KEY);
    }

    default public Float getStateOfHealthPercentage() {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, STATE_OF_HEALTH_PERCENTAGE_KEY);
    }

    default public Long getAvailableEnergy() {
        return this.asSampleOperations().getSampleLong(DatumSamplesType.Instantaneous, AVAILABLE_WATT_HOURS_KEY);
    }

    default public Long getEnergyCapacity() {
        return this.asSampleOperations().getSampleLong(DatumSamplesType.Status, CAPACITY_WATT_HOURS_KEY);
    }
}

