/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.domain.KeyValuePair;
import net.solarnetwork.domain.SerializeIgnore;
import net.solarnetwork.domain.datum.DatumMetadataOperations;
import net.solarnetwork.domain.datum.DatumSupport;
import net.solarnetwork.domain.datum.MutableDatumMetadataOperations;
import net.solarnetwork.util.NumberUtils;
import net.solarnetwork.util.StringUtils;

@JsonPropertyOrder(value={"m", "pm", "t"})
@JsonIgnoreProperties(value={"empty", "infoKeys"})
public class GeneralDatumMetadata
extends DatumSupport
implements DatumMetadataOperations,
MutableDatumMetadataOperations,
Serializable {
    private static final long serialVersionUID = -2571643375746163527L;
    private Map<String, Object> info;
    private Map<String, Map<String, Object>> propertyInfo;

    public GeneralDatumMetadata() {
    }

    public GeneralDatumMetadata(GeneralDatumMetadata other) {
        if (other.getTags() != null) {
            this.setTags(new LinkedHashSet<String>(other.getTags()));
        }
        if (other.info != null) {
            this.info = new LinkedHashMap<String, Object>(other.info);
        }
        if (other.propertyInfo != null) {
            this.propertyInfo = new LinkedHashMap<String, Map<String, Object>>(other.propertyInfo.size());
            for (Map.Entry<String, Map<String, Object>> me : other.propertyInfo.entrySet()) {
                this.propertyInfo.put(me.getKey(), new LinkedHashMap<String, Object>(me.getValue()));
            }
        }
    }

    public GeneralDatumMetadata(Map<String, Object> info) {
        this.info = info;
    }

    public GeneralDatumMetadata(Map<String, Object> info, Map<String, Map<String, Object>> propertyInfo) {
        this.info = info;
        this.propertyInfo = propertyInfo;
    }

    public void populate(KeyValuePair[] data) {
        int len = data != null ? data.length : 0;
        for (int i = 0; i < len; ++i) {
            KeyValuePair kv = data[i];
            if (kv == null) continue;
            String key = kv.getKey();
            if (key != null) {
                key = key.trim();
            }
            if (key == null || key.isEmpty()) continue;
            String val = kv.getValue();
            if (val != null) {
                val = val.trim();
            }
            Number numVal = NumberUtils.narrow(StringUtils.numberValue(val), 2);
            if (key.startsWith("/")) {
                String[] components = key.split("/");
                int idx = 0;
                if (components[0].isEmpty()) {
                    ++idx;
                }
                Map<String, Object> root = null;
                if ("m".equals(components[idx]) && idx + 1 < components.length) {
                    root = this.getInfo();
                    if (root == null) {
                        root = new LinkedHashMap<String, Object>(8);
                        this.setInfo(root);
                    }
                    ++idx;
                } else if ("pm".equals(components[idx]) && idx + 2 < components.length) {
                    root = this.getPropertyInfo();
                    if (root == null) {
                        root = new LinkedHashMap<String, Object>();
                        this.setPropertyInfo(root);
                    }
                    ++idx;
                } else if ("t".equals(components[idx])) {
                    Set<String> tags = this.getTags();
                    if (tags == null) {
                        tags = new LinkedHashSet<String>(8);
                        this.setTags(tags);
                    }
                    tags.add(val);
                }
                if (root == null) continue;
                this.putMetadataAtPath(components, idx, root, numVal != null ? numVal : val);
                continue;
            }
            this.putInfoValue(key, numVal != null ? numVal : val);
        }
    }

    private void putMetadataAtPath(String[] components, int idx, Map<String, Object> root, Object value) {
        if (idx + 1 < components.length) {
            LinkedHashMap nested = root.get(components[idx]);
            if (!(nested instanceof Map)) {
                nested = new LinkedHashMap(8);
                root.put(components[idx], nested);
            }
            this.putMetadataAtPath(components, idx + 1, nested, value);
            return;
        }
        root.put(components[idx], value);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("GeneralDatumMetadata{");
        if (this.info != null && !this.info.isEmpty()) {
            buf.append("m=").append(this.info).append(", ");
        }
        if (this.propertyInfo != null && !this.propertyInfo.isEmpty()) {
            buf.append("pm=").append(this.propertyInfo).append(", ");
        }
        if (this.getTags() != null && !this.getTags().isEmpty()) {
            buf.append("t=").append(this.getTags());
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public void clear() {
        super.clear();
        this.info = null;
        this.propertyInfo = null;
    }

    @Override
    @JsonIgnore
    public Set<String> getPropertyInfoKeys() {
        return this.propertyInfo != null ? this.propertyInfo.keySet() : Collections.emptySet();
    }

    @Override
    @JsonIgnore
    public Map<String, ?> getPropertyInfo(String key) {
        return this.propertyInfo != null ? this.propertyInfo.get(key) : null;
    }

    @Override
    public void merge(DatumMetadataOperations meta, boolean replace) {
        block10: {
            Set<String> propKeys;
            if (meta.getTags() != null) {
                for (String string : meta.getTags()) {
                    this.addTag(string);
                }
            }
            if (meta.getInfo() != null) {
                for (Map.Entry entry : meta.getInfo().entrySet()) {
                    if (!replace && this.getInfo() != null && this.getInfo().containsKey(entry.getKey())) continue;
                    this.putInfoValue((String)entry.getKey(), entry.getValue());
                }
            }
            if ((propKeys = meta.getPropertyInfoKeys()) == null) break block10;
            Map<String, Map<String, Object>> map = this.getPropertyInfo();
            if (map == null) {
                for (String propKey : propKeys) {
                    this.setInfo(propKey, new LinkedHashMap<String, Object>(meta.getPropertyInfo(propKey)));
                }
            } else {
                for (String propKey : propKeys) {
                    if (map.get(propKey) == null) {
                        map.put(propKey, new LinkedHashMap(meta.getPropertyInfo(propKey)));
                        continue;
                    }
                    Map<String, ?> pi = meta.getPropertyInfo(propKey);
                    if (pi == null) continue;
                    for (Map.Entry<String, ?> pme : pi.entrySet()) {
                        if (!replace && map.get(propKey).containsKey(pme.getKey())) continue;
                        this.putInfoValue(propKey, pme.getKey(), pme.getValue());
                    }
                }
            }
        }
    }

    @Override
    public void putInfoValue(String key, Object value) {
        Map<String, Object> m = this.info;
        if (m == null) {
            if (value == null) {
                return;
            }
            this.info = m = new LinkedHashMap<String, Object>(4);
        }
        if (value == null) {
            m.remove(key);
        } else {
            m.put(key, value);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        result = 31 * result + (this.propertyInfo == null ? 0 : this.propertyInfo.hashCode());
        result = 31 * result + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneralDatumMetadata other = (GeneralDatumMetadata)obj;
        if (this.info == null ? other.info != null : !this.info.equals(other.info)) {
            return false;
        }
        if (this.propertyInfo == null ? other.propertyInfo != null : !this.propertyInfo.equals(other.propertyInfo)) {
            return false;
        }
        return !(this.getTags() == null ? other.getTags() != null : !this.getTags().equals(other.getTags()));
    }

    @JsonIgnore
    @SerializeIgnore
    public Map<String, Object> getInfo() {
        return this.info;
    }

    @Override
    public void setInfo(Map<String, Object> info) {
        this.info = info;
    }

    public Map<String, Object> getM() {
        return this.getInfo();
    }

    public void setM(Map<String, Object> map) {
        this.setInfo(map);
    }

    @JsonIgnore
    @SerializeIgnore
    public Map<String, Map<String, Object>> getPropertyInfo() {
        return this.propertyInfo;
    }

    @Override
    public void setInfo(String key, Map<String, Object> info) {
        Map<String, Map<String, Object>> map = this.getPropertyInfo();
        if (map == null) {
            map = new LinkedHashMap<String, Map<String, Object>>(8);
            this.setPropertyInfo(map);
        }
        if (info == null) {
            map.remove(key);
        } else {
            map.put(key, info);
        }
    }

    public void setPropertyInfo(Map<String, Map<String, Object>> propertyInfo) {
        this.propertyInfo = propertyInfo;
    }

    public Map<String, Map<String, Object>> getPm() {
        return this.getPropertyInfo();
    }

    public void setPm(Map<String, Map<String, Object>> map) {
        this.setPropertyInfo(map);
    }

    @Override
    public void putInfoValue(String property, String key, Object value) {
        Map<String, Object> m;
        Map<String, Map<String, Object>> pm = this.propertyInfo;
        if (pm == null) {
            if (value == null) {
                return;
            }
            this.propertyInfo = pm = new LinkedHashMap<String, Map<String, Object>>(4);
        }
        if ((m = pm.get(property)) == null) {
            if (value == null) {
                return;
            }
            m = new LinkedHashMap<String, Object>(4);
            pm.put(property, m);
        }
        if (value == null) {
            m.remove(key);
        } else {
            m.put(key, value);
        }
    }

    @Override
    public Object metadataAtPath(String path) {
        return GeneralDatumMetadata.metadataAtPath(path, this);
    }

    @Override
    public <T> T metadataAtPath(String path, Class<T> clazz) {
        Object o = this.metadataAtPath(path);
        if (o != null && clazz.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        return null;
    }

    public static Object metadataAtPath(String path, GeneralDatumMetadata meta) {
        if (path == null || path.isEmpty() || meta == null) {
            return null;
        }
        Object result = null;
        String[] components = path.split("/");
        int idx = 0;
        if (components[0].isEmpty()) {
            ++idx;
        }
        if ("m".equals(components[idx])) {
            return GeneralDatumMetadata.metadataAtPath(components, idx + 1, meta.getM());
        }
        if ("pm".equals(components[idx])) {
            return GeneralDatumMetadata.metadataAtPath(components, idx + 1, meta.getPm());
        }
        if ("t".equals(components[idx])) {
            Set<String> tags = meta.getT();
            if (idx + 1 < components.length) {
                String tag = components[idx + 1];
                return tags.contains(tag) ? tag : null;
            }
            return tags;
        }
        return result;
    }

    public static <T> T metadataAtPath(String path, GeneralDatumMetadata meta, Class<T> clazz) {
        Object o = GeneralDatumMetadata.metadataAtPath(path, meta);
        if (o != null && clazz.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        return null;
    }

    private static Object metadataAtPath(String[] pathComponents, int idx, Map<String, ?> data) {
        if (data == null) {
            return null;
        }
        if (idx >= pathComponents.length) {
            return data;
        }
        Object v = data.get(pathComponents[idx]);
        if (idx == pathComponents.length - 1) {
            return v;
        }
        if (v instanceof Map) {
            Map m = (Map)v;
            return GeneralDatumMetadata.metadataAtPath(pathComponents, idx + 1, m);
        }
        return null;
    }
}

