/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.domain.datum.DatumSamplesType;

public interface MutableDatumSamplesOperations
extends DatumSamplesOperations {
    public void clear();

    public void putSampleValue(DatumSamplesType var1, String var2, Object var3);

    public void setSampleData(DatumSamplesType var1, Map<String, ?> var2);

    public void setTags(Set<String> var1);

    default public boolean addTag(String tag) {
        Set<String> tags = this.getTags();
        if (tags == null) {
            tags = new LinkedHashSet<String>(2);
            this.setTags(tags);
        }
        return tags.add(tag);
    }

    default public boolean removeTag(String ... tags) {
        Set<String> tagSet = this.getTags();
        if (tagSet == null || tagSet.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (String tag : tags) {
            if (!tagSet.remove(tag)) continue;
            changed = true;
        }
        return changed;
    }

    default public void copyFrom(DatumSamplesOperations other) {
        if (other == null) {
            return;
        }
        Map<String, ?> m = other.getSampleData(DatumSamplesType.Instantaneous);
        if (m != null) {
            this.setSampleData(DatumSamplesType.Instantaneous, new LinkedHashMap(m));
        }
        if ((m = other.getSampleData(DatumSamplesType.Accumulating)) != null) {
            this.setSampleData(DatumSamplesType.Accumulating, new LinkedHashMap(m));
        }
        if ((m = other.getSampleData(DatumSamplesType.Status)) != null) {
            this.setSampleData(DatumSamplesType.Status, new LinkedHashMap(m));
        }
        if (other.getTags() != null) {
            this.setTags(new LinkedHashSet<String>(other.getTags()));
        }
    }

    default public void mergeFrom(DatumSamplesOperations other) {
        this.mergeFrom(other, true);
    }

    default public void mergeFrom(DatumSamplesOperations other, boolean overwrite) {
        for (DatumSamplesType type : DatumSamplesType.values()) {
            if (type != DatumSamplesType.Tag) {
                Map<String, ?> otherData = other.getSampleData(type);
                if (otherData == null) continue;
                Map<String, ?> data = this.getSampleData(type);
                if (data == null) {
                    this.setSampleData(type, otherData);
                    continue;
                }
                if (overwrite) {
                    data.putAll(otherData);
                    continue;
                }
                for (Map.Entry<String, ?> e : otherData.entrySet()) {
                    data.putIfAbsent(e.getKey(), e.getValue());
                }
                continue;
            }
            Set<String> otherTags = other.getTags();
            if (otherTags == null) continue;
            Set<String> tags = this.getTags();
            if (tags == null) {
                this.setTags(otherTags);
                continue;
            }
            tags.addAll(otherTags);
        }
    }
}

