/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.solarnetwork.domain.datum.DatumSamplePropertyConfig;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.util.NumberUtils;

public class NumberDatumSamplePropertyConfig<V>
extends DatumSamplePropertyConfig<V> {
    public static final DatumSamplesType DEFAULT_PROPERTY_TYPE = DatumSamplesType.Instantaneous;
    public static final BigDecimal DEFAULT_SLOPE = BigDecimal.ONE;
    public static final BigDecimal DEFAULT_INTERCEPT = BigDecimal.ZERO;
    public static final int DEFAULT_DECIMAL_SCALE = 5;
    private BigDecimal slope = DEFAULT_SLOPE;
    private BigDecimal intercept = DEFAULT_INTERCEPT;
    private BigDecimal unitSlope = DEFAULT_SLOPE;
    private BigDecimal unitIntercept = DEFAULT_INTERCEPT;
    private int decimalScale = 5;

    public NumberDatumSamplePropertyConfig() {
        super(null, DEFAULT_PROPERTY_TYPE, null);
    }

    public NumberDatumSamplePropertyConfig(String propertyKey, DatumSamplesType propertyType, V config) {
        super(propertyKey, propertyType != null ? propertyType : DEFAULT_PROPERTY_TYPE, config);
    }

    public static List<SettingSpecifier> numberTransformSettings(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>();
        result.add(new BasicTextFieldSettingSpecifier(prefix + "unitIntercept", DEFAULT_INTERCEPT.toString()));
        result.add(new BasicTextFieldSettingSpecifier(prefix + "unitSlope", DEFAULT_SLOPE.toString()));
        result.add(new BasicTextFieldSettingSpecifier(prefix + "slope", DEFAULT_SLOPE.toString()));
        result.add(new BasicTextFieldSettingSpecifier(prefix + "intercept", DEFAULT_INTERCEPT.toString()));
        return result;
    }

    public Number applyTransformations(Number value) {
        if (value == null) {
            return null;
        }
        return NumberUtils.maximumDecimalScale(NumberUtils.offset(NumberUtils.multiplied(NumberUtils.multiplied(NumberUtils.offset(value, this.unitIntercept), this.unitSlope), this.slope), this.intercept), this.decimalScale);
    }

    public BigDecimal getSlope() {
        return this.slope;
    }

    public void setSlope(BigDecimal slope) {
        this.slope = slope != null ? slope : DEFAULT_SLOPE;
    }

    public BigDecimal getIntercept() {
        return this.intercept;
    }

    public void setIntercept(BigDecimal intercept) {
        this.intercept = intercept != null ? intercept : DEFAULT_INTERCEPT;
    }

    public BigDecimal getUnitSlope() {
        return this.unitSlope;
    }

    public void setUnitSlope(BigDecimal unitSlope) {
        this.unitSlope = unitSlope != null ? unitSlope : DEFAULT_SLOPE;
    }

    public BigDecimal getUnitIntercept() {
        return this.unitIntercept;
    }

    public void setUnitIntercept(BigDecimal unitIntercept) {
        this.unitIntercept = unitIntercept != null ? unitIntercept : DEFAULT_INTERCEPT;
    }

    public int getDecimalScale() {
        return this.decimalScale;
    }

    public void setDecimalScale(int decimalScale) {
        this.decimalScale = decimalScale;
    }
}

