/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.tariff;

import java.math.BigDecimal;
import java.util.Objects;
import net.solarnetwork.domain.tariff.Tariff;
import net.solarnetwork.util.StringUtils;

public class SimpleTariffRate
implements Tariff.Rate {
    private final String id;
    private final String description;
    private final BigDecimal amount;

    public SimpleTariffRate(String description, BigDecimal amount) {
        this(StringUtils.simpleIdValue(description), description, amount);
    }

    public SimpleTariffRate(String id, String description, BigDecimal amount) {
        if (id == null) {
            throw new IllegalArgumentException("The id argument must not be null.");
        }
        this.id = id;
        if (description == null) {
            throw new IllegalArgumentException("The description argument must not be null.");
        }
        this.description = description;
        if (amount == null) {
            throw new IllegalArgumentException("The amount argument must not be null.");
        }
        this.amount = amount;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimpleTariffRate{");
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
            builder.append(", ");
        }
        if (this.amount != null) {
            builder.append("amount=");
            builder.append(this.amount);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public BigDecimal getAmount() {
        return this.amount;
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleTariffRate)) {
            return false;
        }
        SimpleTariffRate other = (SimpleTariffRate)obj;
        return Objects.equals(this.amount, other.amount) && Objects.equals(this.id, other.id);
    }
}

