/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.tariff;

import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.solarnetwork.domain.tariff.CompositeTariff;
import net.solarnetwork.domain.tariff.SimpleTemporalRangesTariffEvaluator;
import net.solarnetwork.domain.tariff.Tariff;
import net.solarnetwork.domain.tariff.TariffSchedule;
import net.solarnetwork.domain.tariff.TemporalRangesTariff;
import net.solarnetwork.domain.tariff.TemporalRangesTariffEvaluator;
import net.solarnetwork.domain.tariff.TemporalTariff;

public class SimpleTemporalTariffSchedule
implements TariffSchedule {
    public static final TemporalRangesTariffEvaluator DEFAULT_EVALUATOR = new SimpleTemporalRangesTariffEvaluator();
    public static final boolean DEFAULT_FIRST_MATCH_ONLY = true;
    static final ChronoField[] FIELDS = new ChronoField[]{ChronoField.MONTH_OF_YEAR, ChronoField.DAY_OF_MONTH, ChronoField.DAY_OF_WEEK, ChronoField.MINUTE_OF_DAY};
    private final List<TemporalRangesTariff> rules;
    private final TemporalRangesTariffEvaluator evaluator;
    private boolean firstMatchOnly = true;

    public SimpleTemporalTariffSchedule(Iterable<TemporalRangesTariff> rules) {
        this(rules, null);
    }

    public SimpleTemporalTariffSchedule(Iterable<TemporalRangesTariff> rules, TemporalRangesTariffEvaluator evaluator) {
        if (rules == null) {
            throw new IllegalArgumentException("The rules argument must not be null.");
        }
        this.rules = StreamSupport.stream(rules.spliterator(), false).collect(Collectors.toList());
        this.evaluator = evaluator != null ? evaluator : DEFAULT_EVALUATOR;
    }

    @Override
    public Tariff resolveTariff(LocalDateTime dateTime, Map<String, ?> parameters) {
        boolean firstOnly = this.isFirstMatchOnly();
        ArrayList<TemporalTariff> matches = firstOnly ? null : new ArrayList<TemporalTariff>(this.rules.size());
        for (TemporalRangesTariff rule : this.rules) {
            if (!rule.applies(this.evaluator, dateTime, parameters)) continue;
            TemporalTariff t = rule.toTemporalTariff(dateTime);
            if (firstOnly) {
                return t;
            }
            matches.add(t);
        }
        if (matches == null || matches.isEmpty()) {
            return null;
        }
        return matches.size() == 1 ? (Tariff)matches.get(0) : new CompositeTariff(matches).toTemporalTariff(dateTime);
    }

    public boolean isFirstMatchOnly() {
        return this.firstMatchOnly;
    }

    public void setFirstMatchOnly(boolean firstMatchOnly) {
        this.firstMatchOnly = firstMatchOnly;
    }

    public List<TemporalRangesTariff> getRules() {
        return this.rules;
    }
}

