/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.tariff;

import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.solarnetwork.domain.tariff.Tariff;
import net.solarnetwork.domain.tariff.TemporalRangesTariffEvaluator;
import net.solarnetwork.util.DateUtils;
import net.solarnetwork.util.IntRange;

public class TemporalRangesTariff
implements Tariff {
    private final IntRange monthRange;
    private final IntRange dayOfMonthRange;
    private final IntRange dayOfWeekRange;
    private final IntRange minuteOfDayRange;
    private final Map<String, Tariff.Rate> rates;

    public TemporalRangesTariff(IntRange monthRange, IntRange dayOfMonthRange, IntRange dayOfWeekRange, IntRange minuteOfDayRange, List<Tariff.Rate> rates) {
        this.monthRange = monthRange;
        this.dayOfMonthRange = dayOfMonthRange;
        this.dayOfWeekRange = dayOfWeekRange;
        this.minuteOfDayRange = minuteOfDayRange;
        this.rates = rates == null ? Collections.emptyMap() : (Map)rates.stream().collect(Collectors.toMap(Tariff.Rate::getId, Function.identity(), (k, v) -> v, LinkedHashMap::new));
    }

    public TemporalRangesTariff(String monthRange, String dayOfMonthRange, String dayOfWeekRange, String minuteOfDayRange, List<Tariff.Rate> rates, Locale locale) {
        this.monthRange = DateUtils.parseMonthRange(monthRange, locale);
        this.dayOfMonthRange = DateUtils.parseDayOfMonthRange(dayOfMonthRange, locale);
        this.dayOfWeekRange = DateUtils.parseDayOfWeekRange(dayOfWeekRange, locale);
        this.minuteOfDayRange = DateUtils.parseMinuteOfDayRange(minuteOfDayRange, locale);
        this.rates = rates.stream().collect(Collectors.toMap(Tariff.Rate::getId, Function.identity(), (k, v) -> v, LinkedHashMap::new));
    }

    @Override
    public Map<String, Tariff.Rate> getRates() {
        return this.rates;
    }

    public IntRange rangeForField(ChronoField field) {
        switch (field) {
            case MONTH_OF_YEAR: {
                return this.getMonthRange();
            }
            case DAY_OF_MONTH: {
                return this.getDayOfMonthRange();
            }
            case DAY_OF_WEEK: {
                return this.getDayOfWeekRange();
            }
            case MINUTE_OF_DAY: {
                return this.getMinuteOfDayRange();
            }
        }
        return null;
    }

    public boolean applies(TemporalRangesTariffEvaluator evaluator, LocalDateTime dateTime, Map<String, ?> parameters) {
        return evaluator.applies(this, dateTime, parameters);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TemporalRangesTariff{");
        if (this.monthRange != null) {
            builder.append("months=");
            builder.append(this.monthRange);
            builder.append(", ");
        }
        if (this.dayOfMonthRange != null) {
            builder.append("days=");
            builder.append(this.dayOfMonthRange);
            builder.append(", ");
        }
        if (this.dayOfWeekRange != null) {
            builder.append("dows=");
            builder.append(this.dayOfWeekRange);
            builder.append(", ");
        }
        if (this.minuteOfDayRange != null) {
            builder.append("times=");
            builder.append(this.minuteOfDayRange);
            builder.append(", ");
        }
        if (this.rates != null) {
            builder.append("rates={");
            builder.append(this.rates.values().stream().map(r -> String.format("%s=%s", r.getId(), r.getAmount())).collect(Collectors.joining(",")));
            builder.append("}");
        }
        builder.append("}");
        return builder.toString();
    }

    public IntRange getMonthRange() {
        return this.monthRange;
    }

    public IntRange getDayOfMonthRange() {
        return this.dayOfMonthRange;
    }

    public IntRange getDayOfWeekRange() {
        return this.dayOfWeekRange;
    }

    public IntRange getMinuteOfDayRange() {
        return this.minuteOfDayRange;
    }
}

