/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASCII85OutputStream
extends FilterOutputStream {
    public static final int MAX_CHARS_PER_LINE = 80;
    public static long a85p1 = 85L;
    public static long a85p2 = a85p1 * a85p1;
    public static long a85p3 = a85p2 * a85p1;
    public static long a85p4 = a85p3 * a85p1;
    private boolean end = false;
    private int characters = 80;
    private final int[] b = new int[4];
    private int bIndex = 0;
    private final int[] c = new int[5];

    public ASCII85OutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int a) throws IOException {
        this.b[this.bIndex] = a & 0xFF;
        ++this.bIndex;
        if (this.bIndex >= this.b.length) {
            this.writeTuple();
            this.bIndex = 0;
        }
    }

    public void finish() throws IOException {
        if (!this.end) {
            this.end = true;
            if (this.bIndex > 0) {
                this.writeTuple();
            }
            this.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.finish();
        super.close();
    }

    private void writeTuple() throws IOException {
        for (int i = this.bIndex; i < this.b.length; ++i) {
            this.b[i] = 0;
        }
        long d = (long)(this.b[0] << 24 | this.b[1] << 16 | this.b[2] << 8 | this.b[3]) & 0xFFFFFFFFL;
        this.c[0] = (int)(d / a85p4 + 33L);
        this.c[1] = (int)((d %= a85p4) / a85p3 + 33L);
        this.c[2] = (int)((d %= a85p3) / a85p2 + 33L);
        this.c[3] = (int)((d %= a85p2) / a85p1 + 33L);
        this.c[4] = (int)(d % a85p1 + 33L);
        if (this.bIndex >= this.b.length && this.c[0] == 33 && this.c[1] == 33 && this.c[2] == 33 && this.c[3] == 33 && this.c[4] == 33) {
            this.writeChar(122);
        } else {
            for (int i = 0; i < this.bIndex + 1; ++i) {
                this.writeChar(this.c[i]);
            }
        }
    }

    private void writeChar(int b) throws IOException {
        if (this.characters == 0) {
            this.characters = 80;
            super.write(10);
        }
        --this.characters;
        super.write(b);
    }
}

