/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.io.ByteArrayOutputStream;

public class Base91 {
    public static final byte[] ENCODING_TABLE;
    private static final byte[] DECODING_TABLE;
    private static final int BASE;
    private static final float AVERAGE_ENCODING_RATIO = 1.2297f;

    public static byte[] encode(byte[] data) {
        int estimatedSize = (int)Math.ceil((float)data.length * 1.2297f);
        ByteArrayOutputStream output = new ByteArrayOutputStream(estimatedSize);
        int ebq = 0;
        int en = 0;
        for (int i = 0; i < data.length; ++i) {
            ebq |= (data[i] & 0xFF) << en;
            if ((en += 8) <= 13) continue;
            int ev = ebq & 0x1FFF;
            if (ev > 88) {
                ebq >>= 13;
                en -= 13;
            } else {
                ev = ebq & 0x3FFF;
                ebq >>= 14;
                en -= 14;
            }
            output.write(ENCODING_TABLE[ev % BASE]);
            output.write(ENCODING_TABLE[ev / BASE]);
        }
        if (en > 0) {
            output.write(ENCODING_TABLE[ebq % BASE]);
            if (en > 7 || ebq > 90) {
                output.write(ENCODING_TABLE[ebq / BASE]);
            }
        }
        return output.toByteArray();
    }

    public static byte[] decode(byte[] data) {
        int dbq = 0;
        int dn = 0;
        int dv = -1;
        int estimatedSize = Math.round((float)data.length / 1.2297f);
        ByteArrayOutputStream output = new ByteArrayOutputStream(estimatedSize);
        for (int i = 0; i < data.length; ++i) {
            if (DECODING_TABLE[data[i]] == -1) continue;
            if (dv == -1) {
                dv = DECODING_TABLE[data[i]];
                continue;
            }
            dbq |= (dv += DECODING_TABLE[data[i]] * BASE) << dn;
            dn += (dv & 0x1FFF) > 88 ? 13 : 14;
            do {
                output.write((byte)dbq);
                dbq >>= 8;
            } while ((dn -= 8) > 7);
            dv = -1;
        }
        if (dv != -1) {
            output.write((byte)(dbq | dv << dn));
        }
        return output.toByteArray();
    }

    static {
        int i;
        String ts = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!#$%&()*+,./:;<=>?@[]^_`{|}~\"";
        ENCODING_TABLE = ts.getBytes();
        BASE = ENCODING_TABLE.length;
        DECODING_TABLE = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base91.DECODING_TABLE[i] = -1;
        }
        for (i = 0; i < BASE; ++i) {
            Base91.DECODING_TABLE[Base91.ENCODING_TABLE[i]] = (byte)i;
        }
    }
}

