/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;

public class ConcatenatingInputStream
extends InputStream {
    private final Queue<InputStream> streams;

    public ConcatenatingInputStream(Collection<InputStream> streams) {
        this.streams = streams instanceof Queue ? (Queue<Object>)streams : new LinkedList<InputStream>(streams);
    }

    public ConcatenatingInputStream(InputStream[] streams) {
        this.streams = new LinkedList<InputStream>();
        for (InputStream stream : streams) {
            this.streams.add(stream);
        }
    }

    @Override
    public int read() throws IOException {
        while (!this.streams.isEmpty()) {
            InputStream stream = this.streams.peek();
            int res = stream.read();
            if (res != -1) {
                return res;
            }
            this.streams.remove();
            stream.close();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (!this.streams.isEmpty()) {
            InputStream stream = this.streams.peek();
            int res = stream.read(b, off, len);
            if (res != -1) {
                return res;
            }
            this.streams.remove();
            stream.close();
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        while (!this.streams.isEmpty()) {
            InputStream stream = this.streams.remove();
            stream.close();
        }
    }
}

