/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.solarnetwork.io.ConcatenatingInputStream;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class ConcatenatingResource
extends AbstractResource
implements Resource {
    private final List<Resource> delegates;

    public ConcatenatingResource(Collection<Resource> resources) {
        this.delegates = resources == null ? Collections.emptyList() : (resources instanceof List ? (List<Object>)resources : new ArrayList<Resource>(resources));
    }

    private Resource getDelegate() throws IOException {
        if (this.delegates.isEmpty()) {
            throw new IOException("No resource available");
        }
        return this.delegates.get(0);
    }

    public InputStream getInputStream() throws IOException {
        InputStream[] streams = new InputStream[this.delegates.size()];
        int i = 0;
        for (Resource r : this.delegates) {
            streams[i] = r.getInputStream();
            ++i;
        }
        return new ConcatenatingInputStream(streams);
    }

    public long contentLength() throws IOException {
        long total = 0L;
        for (Resource r : this.delegates) {
            total += r.contentLength();
        }
        return total;
    }

    public long lastModified() throws IOException {
        return this.getDelegate().lastModified();
    }

    public String getDescription() {
        StringBuilder buf = new StringBuilder("ConcatenatingResource{");
        int i = 0;
        for (Resource r : this.delegates) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(r.getDescription());
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    public String toString() {
        return this.getDescription();
    }
}

