/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.springframework.core.io.Resource;

public class DeleteOnCloseFileResource
implements Resource {
    private final File file;
    private final Resource delegate;

    public DeleteOnCloseFileResource(Resource delegate) throws IOException {
        this(delegate, delegate.getFile());
    }

    public DeleteOnCloseFileResource(Resource delegate, File file) {
        this.delegate = delegate;
        this.file = file;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DeleteOnCloseFileResource{");
        if (this.file != null) {
            builder.append("file=");
            builder.append(this.file);
            builder.append(", ");
        }
        if (this.delegate != null) {
            builder.append("resource=");
            builder.append(this.delegate);
        }
        builder.append("}");
        return builder.toString();
    }

    public InputStream getInputStream() throws IOException {
        return new DeleteFileOnCloseInputStream(this.delegate.getInputStream());
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public boolean isReadable() {
        return this.delegate.isReadable();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public URL getURL() throws IOException {
        return this.delegate.getURL();
    }

    public URI getURI() throws IOException {
        return this.delegate.getURI();
    }

    public File getFile() throws IOException {
        return this.delegate.getFile();
    }

    public long contentLength() throws IOException {
        return this.delegate.contentLength();
    }

    public long lastModified() throws IOException {
        return this.delegate.lastModified();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.delegate.createRelative(relativePath);
    }

    public String getFilename() {
        return this.delegate.getFilename();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    private class DeleteFileOnCloseInputStream
    extends InputStream {
        private final InputStream delegate;

        private DeleteFileOnCloseInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                DeleteOnCloseFileResource.this.file.delete();
            }
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

