/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.solarnetwork.io.RFC1924OutputStream;

public class RFC1924InputStream
extends FilterInputStream {
    private static final byte[] DECODABET;
    private int factor = 5;
    private long sum = 0L;
    private int e = 24;
    private boolean eof = false;

    public RFC1924InputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        while (!this.eof && this.factor > 0) {
            int b = super.read();
            if (b == -1) {
                this.eof = true;
                break;
            }
            this.sum += (long)DECODABET[b] * RFC1924OutputStream.FACTORS[--this.factor];
        }
        if (this.factor == 0 && !this.eof) {
            int result = (int)(this.sum >>> this.e & 0xFFL);
            this.e -= 8;
            if (this.e < 0) {
                this.e = 24;
                this.factor = 5;
                this.sum = 0L;
            }
            return result;
        }
        if (this.factor < 5 && this.e >= 0) {
            if (this.e == 24) {
                this.sum /= RFC1924OutputStream.FACTORS[this.factor];
                this.e = (3 - this.factor) * 8;
            }
            int result = (int)(this.sum >>> this.e & 0xFFL);
            this.e -= 8;
            return result;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int d;
        int i;
        if (this.eof) {
            return -1;
        }
        int stop = off + len;
        for (i = off; i < b.length && i < stop && (d = this.read()) != -1; ++i) {
            b[i] = (byte)d;
        }
        return i - off;
    }

    static {
        int i;
        DECODABET = new byte[256];
        for (i = 0; i < DECODABET.length; ++i) {
            RFC1924InputStream.DECODABET[i] = -1;
        }
        for (i = 0; i < RFC1924OutputStream.ENCODABET.length; ++i) {
            RFC1924InputStream.DECODABET[RFC1924OutputStream.ENCODABET[i] & 0xFF] = (byte)i;
        }
    }
}

