/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RFC1924OutputStream
extends FilterOutputStream {
    static final byte[] ENCODABET = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 33, 35, 36, 37, 38, 40, 41, 42, 43, 45, 59, 60, 61, 62, 63, 64, 94, 95, 96, 123, 124, 125, 126};
    static final long[] FACTORS = new long[]{1L, 85L, 7225L, 614125L, 52200625L};
    private final int[] tuple = new int[4];
    private int bIndex = 0;

    public RFC1924OutputStream(OutputStream out) {
        super(out);
    }

    private void writeTuple() throws IOException {
        int bytes;
        long sum = 0L;
        for (bytes = 0; bytes < this.bIndex; ++bytes) {
            sum = sum << 8 | (long)this.tuple[bytes];
        }
        if (bytes == 4) {
            for (int e = 4; e >= 0; --e) {
                super.write(ENCODABET[(int)(sum / FACTORS[e])]);
                sum %= FACTORS[e];
            }
            sum = 0L;
            bytes = 0;
        } else if (bytes > 0) {
            for (int e = bytes; e >= 0; --e) {
                super.write(ENCODABET[(int)(sum / FACTORS[e])]);
                sum %= FACTORS[e];
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.tuple[this.bIndex++] = b & 0xFF;
        if (this.bIndex >= this.tuple.length) {
            this.writeTuple();
            this.bIndex = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.bIndex > 0 && this.bIndex < this.tuple.length) {
            this.writeTuple();
            this.bIndex = -1;
            this.flush();
        }
    }
}

