/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.security;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.solarnetwork.security.SecurityException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.util.StringUtils;

public class AuthorizationUtils {
    public static final String SN_DATE_HEADER = "x-sn-date";
    public static final String EMPTY_STRING_SHA256_HEX = DigestUtils.sha256Hex((byte[])"".getBytes());
    public static final DateTimeFormatter AUTHORIZATION_DATE_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter().withZone(ZoneId.of("GMT"));
    public static final DateTimeFormatter AUTHORIZATION_DATE_HEADER_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT"));
    public static final DateTimeFormatter AUTHORIZATION_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneId.of("GMT"));

    private AuthorizationUtils() {
    }

    public static byte[] computeHmacSha256(String key, String msg) {
        return AuthorizationUtils.computeMacDigest(key, msg, "HmacSHA256");
    }

    public static byte[] computeHmacSha256(byte[] key, String msg) {
        try {
            return AuthorizationUtils.computeMacDigest(key, msg.getBytes("UTF-8"), "HmacSHA256");
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException("Error loading HmacSHA1 crypto function", e);
        }
    }

    public static byte[] computeMacDigest(String secret, String msg, String alg) {
        try {
            return AuthorizationUtils.computeMacDigest(secret.getBytes("UTF-8"), msg.getBytes("UTF-8"), alg);
        }
        catch (UnsupportedEncodingException e) {
            throw new SecurityException("Error encoding secret or message for crypto function", e);
        }
    }

    public static byte[] computeMacDigest(byte[] key, byte[] msg, String alg) {
        try {
            Mac hmacSha1 = Mac.getInstance(alg);
            hmacSha1.init(new SecretKeySpec(key, alg));
            byte[] result = hmacSha1.doFinal(msg);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("Error loading " + alg + " crypto function", e);
        }
        catch (InvalidKeyException e) {
            throw new SecurityException("Error loading " + alg + " crypto function", e);
        }
    }

    public static String computeHmacSha256Hex(byte[] signingKey, String signatureData) {
        return Hex.encodeHexString((byte[])AuthorizationUtils.computeHmacSha256(signingKey, signatureData));
    }

    public static String uriEncode(CharSequence input) {
        StringBuilder result = new StringBuilder();
        byte[] tmpByteArray = new byte[1];
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-' || ch == '~' || ch == '.') {
                result.append(ch);
                continue;
            }
            try {
                byte[] bytes;
                byte[] byArray = bytes = String.valueOf(ch).getBytes("UTF-8");
                int n = byArray.length;
                for (int j = 0; j < n; ++j) {
                    byte b;
                    tmpByteArray[0] = b = byArray[j];
                    result.append('%').append(Hex.encodeHex((byte[])tmpByteArray, (boolean)false));
                }
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result.toString();
    }

    public static String semiColonDelimitedList(String[] list) {
        return StringUtils.arrayToDelimitedString((Object[])list, (String)";");
    }
}

