/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.security;

import java.util.Map;
import net.solarnetwork.util.StringUtils;

public class SnsAuthorizationInfo {
    private final String scheme;
    private final String identifier;
    private final String[] headerNames;
    private final String signature;

    public static SnsAuthorizationInfo forAuthorizationHeader(String authorizationHeader) {
        if (authorizationHeader == null || authorizationHeader.isEmpty()) {
            throw new IllegalArgumentException("The authorizationHeader must not be null.");
        }
        int sep = (authorizationHeader = authorizationHeader.trim()).indexOf(32);
        if (sep < 0 || sep + 1 >= authorizationHeader.length()) {
            throw new IllegalArgumentException("Invalid authorization header syntax (missing scheme).");
        }
        String scheme = authorizationHeader.substring(0, sep);
        Map<String, String> components = StringUtils.commaDelimitedStringToMap(authorizationHeader.substring(sep + 1));
        if (components == null || components.size() < 3) {
            throw new IllegalArgumentException("Invalid authorization header syntax (missing required comopnents).");
        }
        String cred = components.get("Credential");
        if (cred == null || cred.isEmpty()) {
            throw new IllegalArgumentException("Invalid authorization header syntax (Credential missing).");
        }
        String headers = components.get("SignedHeaders");
        if (headers == null || headers.isEmpty()) {
            throw new IllegalArgumentException("Invalid authorization header syntax (Headers missing).");
        }
        String[] headerNames = org.springframework.util.StringUtils.delimitedListToStringArray((String)headers, (String)";");
        if (headerNames == null || headerNames.length < 1) {
            throw new IllegalArgumentException("Invalid authorization header syntax (Headers empty).");
        }
        String sig = components.get("Signature");
        if (sig == null || sig.isEmpty()) {
            throw new IllegalArgumentException("Invalid authorization header syntax (Signature missing).");
        }
        return new SnsAuthorizationInfo(scheme, cred, headerNames, sig);
    }

    public SnsAuthorizationInfo(String scheme, String identifier, String[] headerNames, String signature) {
        if (scheme == null) {
            throw new IllegalArgumentException("The scheme argument must not be null.");
        }
        this.scheme = scheme;
        if (identifier == null) {
            throw new IllegalArgumentException("The identifier argument must not be null.");
        }
        this.identifier = identifier;
        if (headerNames == null) {
            throw new IllegalArgumentException("The headerNames argument must not be null.");
        }
        this.headerNames = headerNames;
        if (signature == null) {
            throw new IllegalArgumentException("The signature argument must not be null.");
        }
        this.signature = signature;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getHeaderNames() {
        return this.headerNames;
    }

    public String getSignature() {
        return this.signature;
    }
}

