/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.service.support;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import net.solarnetwork.domain.BasicIdentity;
import net.solarnetwork.domain.BasicLocalizedServiceInfo;
import net.solarnetwork.domain.LocalizedServiceInfo;
import net.solarnetwork.service.LocalizedServiceInfoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;

public abstract class BaseLocalizedServiceInfoProvider<PK extends Comparable<PK>>
extends BasicIdentity<PK>
implements LocalizedServiceInfoProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private MessageSource messageSource;

    public BaseLocalizedServiceInfoProvider(PK id) {
        super(id);
    }

    @Override
    public LocalizedServiceInfo getLocalizedServiceInfo(Locale locale) {
        locale = locale != null ? locale : Locale.getDefault();
        String id = this.getId() != null ? this.getId().toString() : "";
        String title = null;
        String desc = null;
        Map<String, String> msgs = Collections.emptyMap();
        MessageSource ms = this.getMessageSource();
        if (ms != null) {
            title = ms.getMessage("title", null, null, locale);
            desc = ms.getMessage("desc", null, null, locale);
            msgs = this.resolveInfoMessages(locale);
        }
        return new BasicLocalizedServiceInfo(id, locale, title, desc, msgs);
    }

    protected Map<String, String> resolveInfoMessages(Locale locale) {
        return Collections.emptyMap();
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

