/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.service.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.solarnetwork.domain.KeyValuePair;
import net.solarnetwork.service.Identifiable;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicGroupSettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.settings.support.SettingUtils;
import net.solarnetwork.util.ArrayUtils;
import net.solarnetwork.util.NumberUtils;
import net.solarnetwork.util.StringUtils;
import org.springframework.context.MessageSource;

public class BasicIdentifiable
implements Identifiable {
    private String uid;
    private String groupUid;
    private String displayName;
    private MessageSource messageSource;
    private KeyValuePair[] metadata;

    public static List<SettingSpecifier> basicIdentifiableSettings() {
        return BasicIdentifiable.basicIdentifiableSettings("", "", "");
    }

    public static List<SettingSpecifier> basicIdentifiableSettings(String prefix) {
        return BasicIdentifiable.basicIdentifiableSettings(prefix, "", "");
    }

    public static List<SettingSpecifier> basicIdentifiableSettings(String prefix, String defaultUid, String defaultGroupUid) {
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(8);
        results.add(new BasicTextFieldSettingSpecifier(prefix + "uid", defaultUid));
        results.add(new BasicTextFieldSettingSpecifier(prefix + "groupUid", defaultGroupUid));
        return results;
    }

    public static List<SettingSpecifier> basicIdentifiableMetadataSettings(String prefix, KeyValuePair[] metadata) {
        if (prefix == null) {
            prefix = "";
        }
        List<Object> exprConfsList = metadata != null ? Arrays.asList(metadata) : Collections.emptyList();
        return Collections.singletonList(SettingUtils.dynamicListSettingSpecifier(prefix + "metadata", exprConfsList, new SettingUtils.KeyedListCallback<KeyValuePair>(){

            @Override
            public Collection<SettingSpecifier> mapListSettingKey(KeyValuePair value, int index, String key) {
                ArrayList<SettingSpecifier> g = new ArrayList<SettingSpecifier>(2);
                g.add(new BasicTextFieldSettingSpecifier(key + ".key", value != null ? value.getKey() : null));
                g.add(new BasicTextFieldSettingSpecifier(key + ".value", value != null ? value.getValue() : null));
                return Collections.singletonList(new BasicGroupSettingSpecifier(g));
            }
        }));
    }

    public String metadataValue(String key) {
        if (key == null) {
            return null;
        }
        KeyValuePair[] data = this.getMetadata();
        if (data != null) {
            for (KeyValuePair p : data) {
                if (p == null || !key.equals(p.getKey())) continue;
                return p.getValue();
            }
        }
        return null;
    }

    public Object smartMetadataValue(String key) {
        Number n;
        String val = this.metadataValue(key);
        if (val != null && (n = NumberUtils.narrow(StringUtils.numberValue(val), 2)) != null) {
            return n;
        }
        return val;
    }

    public Number numberMetadataValue(String key) {
        Object val = this.smartMetadataValue(key);
        return val instanceof Number ? (Number)((Number)val) : (Number)null;
    }

    public Integer integerMetadataValue(String key) {
        Object val = this.smartMetadataValue(key);
        return val instanceof Integer ? (Integer)val : (val instanceof Number ? Integer.valueOf(((Number)val).intValue()) : null);
    }

    public Double doubleMetadataValue(String key) {
        Object val = this.smartMetadataValue(key);
        return val instanceof Double ? (Double)val : (val instanceof Number ? Double.valueOf((Double)val) : null);
    }

    public void saveMetadataValue(String key, Object value, boolean create) {
        if (key == null) {
            return;
        }
        String val = value != null ? value.toString() : null;
        KeyValuePair[] data = this.getMetadata();
        if (data != null) {
            for (KeyValuePair p : data) {
                if (p == null || !key.equals(p.getKey())) continue;
                p.setValue(val);
                return;
            }
        }
        if (create) {
            data = ArrayUtils.arrayWithLength(data, (data == null ? 0 : data.length) + 1, KeyValuePair.class, KeyValuePair::new);
            data[data.length - 1].setKey(key);
            data[data.length - 1].setValue(val);
            this.setMetadata(data);
        }
    }

    public void saveMetadataValue(int index, String key, Object value, boolean create) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        String val = value != null ? value.toString() : null;
        KeyValuePair[] data = this.getMetadata();
        if (data != null && index < data.length) {
            KeyValuePair p = data[index];
            if (p == null && create) {
                data[index] = p = new KeyValuePair(key, val);
            } else if (p != null) {
                p.setKey(key);
                p.setValue(val);
            }
        } else if (create) {
            data = ArrayUtils.arrayWithLength(data, index + 1, KeyValuePair.class, KeyValuePair::new);
            data[index].setKey(key);
            data[index].setValue(val);
            this.setMetadata(data);
        }
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    @Override
    public String getGroupUid() {
        return this.groupUid;
    }

    public void setGroupUid(String groupUid) {
        this.groupUid = groupUid;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Deprecated
    public String getUID() {
        return this.getUid();
    }

    @Deprecated
    public void setUID(String uid) {
        String currUid = this.getUid();
        if (currUid == null || currUid.isEmpty()) {
            this.setUid(uid);
        }
    }

    @Deprecated
    public String getGroupUID() {
        return this.getGroupUid();
    }

    @Deprecated
    public void setGroupUID(String groupUid) {
        String currUid = this.getGroupUid();
        if (currUid == null || currUid.isEmpty()) {
            this.setGroupUid(groupUid);
        }
    }

    public KeyValuePair[] getMetadata() {
        return this.metadata;
    }

    public void setMetadata(KeyValuePair[] metadata) {
        this.metadata = metadata;
    }

    public int getMetadataCount() {
        KeyValuePair[] vals = this.getMetadata();
        return vals == null ? 0 : vals.length;
    }

    public void setMetadataCount(int count) {
        this.setMetadata(ArrayUtils.arrayWithLength(this.getMetadata(), count, KeyValuePair.class, KeyValuePair::new));
    }
}

