/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.service.support;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import net.solarnetwork.service.CertificateException;
import net.solarnetwork.service.SSLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableSSLService
implements SSLService {
    public static final String DEFAULT_KEY_STORE_PATH = "conf/tls/keystore.jks";
    public static final String DEFAULT_TRUST_STORE_PATH = "conf/tls/trust.jks";
    public static final String DEFAULT_PASSWORD = "changeit";
    private String keyStorePath = "conf/tls/keystore.jks";
    private String keyStorePassword = "changeit";
    private String trustStorePath = "conf/tls/trust.jks";
    private String trustStorePassword = "changeit";
    private String jreTrustStorePassword = "changeit";
    private SSLSocketFactory socketFactory;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public static final KeyStore loadKeyStore(String type, InputStream in, String password) {
        if (password == null) {
            password = "";
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(in, password != null ? password.toCharArray() : null);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (GeneralSecurityException e) {
            throw new CertificateException("Error loading certificate key store", e);
        }
        catch (IOException e) {
            String msg = e.getCause() instanceof UnrecoverableKeyException ? "Invalid password loading key store" : "Error loading certificate key store";
            throw new CertificateException(msg, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static final void saveKeyStore(KeyStore keyStore, String password, OutputStream out) {
        if (password == null) {
            password = "";
        }
        try {
            keyStore.store(out, password.toCharArray());
        }
        catch (KeyStoreException e) {
            throw new CertificateException("Error saving certificate key store", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException("Error saving certificate key store", e);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException("Error saving certificate key store", e);
        }
        catch (IOException e) {
            throw new CertificateException("Error saving certificate key store", e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw new CertificateException("Error closing KeyStore stream", e);
                }
            }
        }
    }

    protected synchronized KeyStore loadKeyStore() {
        File ksFile = new File(this.keyStorePath);
        BufferedInputStream in = null;
        String passwd = this.getKeyStorePassword();
        try {
            if (ksFile.isFile()) {
                in = new BufferedInputStream(new FileInputStream(ksFile));
            }
            return ConfigurableSSLService.loadKeyStore(KeyStore.getDefaultType(), in, passwd);
        }
        catch (IOException e) {
            throw new CertificateException("Error opening file " + this.keyStorePath, e);
        }
    }

    protected synchronized KeyStore loadTrustStore() {
        File jdkTrustStoreFile = new File(System.getProperty("java.home"), "lib/security/cacerts");
        KeyStore ks = null;
        BufferedInputStream in = null;
        if (jdkTrustStoreFile.canRead()) {
            try {
                in = new BufferedInputStream(new FileInputStream(jdkTrustStoreFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        ks = ConfigurableSSLService.loadKeyStore(KeyStore.getDefaultType(), in, this.jreTrustStorePassword);
        File snTrustStoreFile = new File(this.trustStorePath);
        if (snTrustStoreFile.canRead()) {
            KeyStore snTrustStore = null;
            try {
                in = new BufferedInputStream(new FileInputStream(snTrustStoreFile));
                snTrustStore = ConfigurableSSLService.loadKeyStore(KeyStore.getDefaultType(), in, this.trustStorePassword);
                Enumeration<String> aliases = snTrustStore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Certificate cert = snTrustStore.getCertificate(alias);
                    if (cert == null) continue;
                    ks.setCertificateEntry(alias, cert);
                }
            }
            catch (FileNotFoundException aliases) {
            }
            catch (KeyStoreException e) {
                this.log.warn("Error processing trusted certs in {}: {}", (Object)snTrustStoreFile, (Object)e.getMessage());
            }
        }
        return ks;
    }

    protected synchronized void resetSocketFactory() {
        this.socketFactory = null;
    }

    @Override
    public TrustManagerFactory getTrustManagerFactory() {
        KeyStore trustStore = this.loadTrustStore();
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
            trustManagerFactory.init(trustStore);
            return trustManagerFactory;
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new CertificateException("Error creating TrustManagerFactory: " + e.toString(), e);
        }
    }

    @Override
    public KeyManagerFactory getKeyManagerFactory() {
        try {
            File ksFile = new File(this.keyStorePath);
            if (ksFile.isFile()) {
                KeyStore keyStore = this.loadKeyStore();
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, this.getKeyStorePassword().toCharArray());
                return keyManagerFactory;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new CertificateException("Error creating KeyManagerFactory: " + e.toString(), e);
        }
        return null;
    }

    @Override
    public synchronized SSLSocketFactory getSSLSocketFactory() {
        if (this.socketFactory == null) {
            try {
                TrustManagerFactory trustManagerFactory = this.getTrustManagerFactory();
                X509TrustManager x509TrustManager = null;
                for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    x509TrustManager = (X509TrustManager)trustManager;
                    break;
                }
                if (x509TrustManager == null) {
                    throw new CertificateException("No X509 TrustManager available");
                }
                KeyManager[] keyManagers = null;
                KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory();
                if (keyManagerFactory != null) {
                    for (KeyManager keyManager : keyManagerFactory.getKeyManagers()) {
                        if (!(keyManager instanceof X509KeyManager)) continue;
                        keyManagers = new KeyManager[]{keyManager};
                    }
                }
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, new TrustManager[]{x509TrustManager}, null);
                this.socketFactory = sslContext.getSocketFactory();
            }
            catch (NoSuchAlgorithmException e) {
                throw new CertificateException("Error creating SSLContext", e);
            }
            catch (KeyManagementException e) {
                throw new CertificateException("Error creating SSLContext", e);
            }
        }
        return this.socketFactory;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    protected String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    protected String getJreTrustStorePassword() {
        return this.jreTrustStorePassword;
    }

    public void setJreTrustStorePassword(String jreTrustStorePassword) {
        this.jreTrustStorePassword = jreTrustStorePassword;
    }

    protected String getKeyStorePassword() {
        String password = this.keyStorePassword;
        if (password != null && password.length() > 0) {
            return password;
        }
        return "";
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }
}

