/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.settings;

import java.util.ArrayList;
import java.util.List;
import net.solarnetwork.settings.SettingSpecifier;

public interface MappableSpecifier {
    public SettingSpecifier mappedTo(String var1);

    public SettingSpecifier mappedWithPlaceholer(String var1);

    public SettingSpecifier mappedWithMapper(Mapper var1);

    public static List<SettingSpecifier> mapTo(List<SettingSpecifier> settings, String prefix) {
        if (settings == null || prefix == null || prefix.isEmpty()) {
            return settings;
        }
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>(settings.size());
        for (SettingSpecifier setting : settings) {
            if (setting instanceof MappableSpecifier) {
                result.add(((MappableSpecifier)((Object)setting)).mappedTo(prefix));
                continue;
            }
            result.add(setting);
        }
        return result;
    }

    public static List<SettingSpecifier> mapWithPlaceholder(List<SettingSpecifier> settings, String template) {
        if (settings == null || template == null) {
            return settings;
        }
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>(settings.size());
        for (SettingSpecifier setting : settings) {
            if (setting instanceof MappableSpecifier) {
                result.add(((MappableSpecifier)((Object)setting)).mappedWithPlaceholer(template));
                continue;
            }
            result.add(setting);
        }
        return result;
    }

    public static List<SettingSpecifier> mapWithMapper(List<SettingSpecifier> settings, Mapper mapper) {
        if (settings == null || mapper == null) {
            return settings;
        }
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>(settings.size());
        for (SettingSpecifier setting : settings) {
            if (setting instanceof MappableSpecifier) {
                result.add(((MappableSpecifier)((Object)setting)).mappedWithMapper(mapper));
                continue;
            }
            result.add(setting);
        }
        return result;
    }

    public static interface Mapper {
        public String mapKey(String var1);
    }
}

