/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.settings.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.solarnetwork.settings.GroupSettingSpecifier;
import net.solarnetwork.settings.MappableSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BaseSettingSpecifier;

public class BasicGroupSettingSpecifier
extends BaseSettingSpecifier
implements GroupSettingSpecifier {
    private final String key;
    private final String footerText;
    private final List<SettingSpecifier> groupSettings;
    private final boolean dynamic;

    public BasicGroupSettingSpecifier(List<SettingSpecifier> settings) {
        this(null, settings, false, null);
    }

    public BasicGroupSettingSpecifier(String groupKey, List<SettingSpecifier> settings) {
        this(groupKey, settings, false, null);
    }

    public BasicGroupSettingSpecifier(String groupKey, List<SettingSpecifier> settings, boolean dynamic) {
        this(groupKey, settings, dynamic, null);
    }

    public BasicGroupSettingSpecifier(String groupKey, List<SettingSpecifier> settings, boolean dynamic, String footerText) {
        this.key = groupKey;
        this.groupSettings = Collections.unmodifiableList(settings);
        this.dynamic = dynamic;
        this.footerText = footerText;
    }

    @Override
    public String getFooterText() {
        return this.footerText;
    }

    @Override
    public List<SettingSpecifier> getGroupSettings() {
        return this.groupSettings;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public SettingSpecifier mappedWithPlaceholer(String template) {
        String key;
        List<SettingSpecifier> gSettings = this.getGroupSettings();
        ArrayList<SettingSpecifier> mappedGroupSettings = null;
        if (gSettings != null) {
            mappedGroupSettings = new ArrayList<SettingSpecifier>(gSettings.size());
            for (SettingSpecifier s : gSettings) {
                if (s instanceof MappableSpecifier) {
                    MappableSpecifier ms = (MappableSpecifier)((Object)s);
                    mappedGroupSettings.add(ms.mappedWithPlaceholer(template));
                    continue;
                }
                mappedGroupSettings.add(s);
            }
        }
        String mappedKey = (key = this.getKey()) == null ? null : String.format(template, key);
        BasicGroupSettingSpecifier spec = new BasicGroupSettingSpecifier(mappedKey, mappedGroupSettings, this.isDynamic(), this.getFooterText());
        spec.setTitle(this.getTitle());
        return spec;
    }

    @Override
    public SettingSpecifier mappedTo(String prefix) {
        return this.mappedWithPlaceholer(prefix + "%s");
    }

    @Override
    public SettingSpecifier mappedWithMapper(MappableSpecifier.Mapper mapper) {
        String key;
        List<SettingSpecifier> gSettings = this.getGroupSettings();
        ArrayList<SettingSpecifier> mappedGroupSettings = null;
        if (gSettings != null) {
            mappedGroupSettings = new ArrayList<SettingSpecifier>(gSettings.size());
            for (SettingSpecifier s : gSettings) {
                if (s instanceof MappableSpecifier) {
                    MappableSpecifier ms = (MappableSpecifier)((Object)s);
                    mappedGroupSettings.add(ms.mappedWithMapper(mapper));
                    continue;
                }
                mappedGroupSettings.add(s);
            }
        }
        String mappedKey = (key = this.getKey()) == null ? null : mapper.mapKey(key);
        BasicGroupSettingSpecifier spec = new BasicGroupSettingSpecifier(mappedKey, mappedGroupSettings, this.isDynamic(), this.getFooterText());
        spec.setTitle(this.getTitle());
        return spec;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("{key=").append(this.key);
        builder.append(",dynamic=").append(this.dynamic);
        builder.append(",count=").append(this.groupSettings == null ? 0 : this.groupSettings.size());
        builder.append("}");
        return builder.toString();
    }
}

