/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.settings.support;

import net.solarnetwork.settings.MappableSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.ToggleSettingSpecifier;
import net.solarnetwork.settings.support.BaseKeyedSettingSpecifier;

public class BasicToggleSettingSpecifier
extends BaseKeyedSettingSpecifier<Object>
implements ToggleSettingSpecifier {
    private Object trueValue = Boolean.TRUE;
    private Object falseValue = Boolean.FALSE;

    public BasicToggleSettingSpecifier(String key, Object defaultValue) {
        super(key, defaultValue);
    }

    public BasicToggleSettingSpecifier(String key, Object defaultValue, boolean trans) {
        super(key, defaultValue, trans);
    }

    @Override
    public Object getTrueValue() {
        return this.trueValue;
    }

    @Override
    public Object getFalseValue() {
        return this.falseValue;
    }

    @Override
    public SettingSpecifier mappedWithPlaceholer(String template) {
        BasicToggleSettingSpecifier spec = new BasicToggleSettingSpecifier(String.format(template, this.getKey()), this.getDefaultValue());
        spec.setTitle(this.getTitle());
        spec.setTrueValue(this.trueValue);
        spec.setFalseValue(this.falseValue);
        return spec;
    }

    @Override
    public SettingSpecifier mappedWithMapper(MappableSpecifier.Mapper mapper) {
        BasicToggleSettingSpecifier spec = new BasicToggleSettingSpecifier(mapper.mapKey(this.getKey()), this.getDefaultValue());
        spec.setTitle(this.getTitle());
        spec.setTrueValue(this.trueValue);
        spec.setFalseValue(this.falseValue);
        return spec;
    }

    public void setTrueValue(Object trueValue) {
        this.trueValue = trueValue;
    }

    public void setFalseValue(Object falseValue) {
        this.falseValue = falseValue;
    }
}

