/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.settings.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.settings.GroupSettingSpecifier;
import net.solarnetwork.settings.KeyedSettingSpecifier;
import net.solarnetwork.settings.MappableSpecifier;
import net.solarnetwork.settings.ParentSettingSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.TextFieldSettingSpecifier;
import net.solarnetwork.settings.support.BasicGroupSettingSpecifier;

public final class SettingUtils {
    private SettingUtils() {
    }

    public static <T> BasicGroupSettingSpecifier dynamicListSettingSpecifier(String key, Collection<T> collection, KeyedListCallback<T> mapper) {
        List<SettingSpecifier> listStringGroupSettings;
        if (collection == null) {
            listStringGroupSettings = Collections.emptyList();
        } else {
            int len = collection.size();
            listStringGroupSettings = new ArrayList(len);
            int i = 0;
            for (T value : collection) {
                Collection<SettingSpecifier> res = mapper.mapListSettingKey(value, i, key + "[" + i + "]");
                ++i;
                if (res == null) continue;
                listStringGroupSettings.addAll(res);
            }
        }
        return new BasicGroupSettingSpecifier(key, listStringGroupSettings, true);
    }

    public static Set<String> secureKeys(List<SettingSpecifier> settings) {
        if (settings == null || settings.isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> secureProps = null;
        for (SettingSpecifier setting : settings) {
            TextFieldSettingSpecifier text;
            if (!(setting instanceof TextFieldSettingSpecifier) || !(text = (TextFieldSettingSpecifier)setting).isSecureTextEntry()) continue;
            String key = text.getKey();
            if (secureProps == null) {
                secureProps = new LinkedHashSet<String>(4);
            }
            secureProps.add(key);
        }
        return secureProps != null ? secureProps : Collections.emptySet();
    }

    public static List<SettingSpecifier> mappedWithPrefix(List<SettingSpecifier> settings, String prefix) {
        if (settings == null || settings.isEmpty() || prefix == null || prefix.isEmpty()) {
            return settings;
        }
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>(settings.size());
        for (SettingSpecifier setting : settings) {
            if (setting instanceof MappableSpecifier) {
                result.add(((MappableSpecifier)((Object)setting)).mappedTo(prefix));
                continue;
            }
            result.add(setting);
        }
        return result;
    }

    public static Map<String, Object> keyedSettingDefaults(List<SettingSpecifier> settings) {
        if (settings == null || settings.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(settings.size());
        SettingUtils.addKeyedSettingDefaults(settings, result);
        return result;
    }

    private static void addKeyedSettingDefaults(List<SettingSpecifier> settings, Map<String, Object> result) {
        if (settings == null || settings.isEmpty()) {
            return;
        }
        for (SettingSpecifier setting : settings) {
            if (setting instanceof KeyedSettingSpecifier) {
                KeyedSettingSpecifier keyed = (KeyedSettingSpecifier)setting;
                result.put(keyed.getKey(), keyed.getDefaultValue());
                continue;
            }
            if (setting instanceof GroupSettingSpecifier) {
                SettingUtils.addKeyedSettingDefaults(((GroupSettingSpecifier)setting).getGroupSettings(), result);
                continue;
            }
            if (!(setting instanceof ParentSettingSpecifier)) continue;
            SettingUtils.addKeyedSettingDefaults(((ParentSettingSpecifier)setting).getChildSettings(), result);
        }
    }

    public static interface KeyedListCallback<T> {
        public Collection<SettingSpecifier> mapListSettingKey(T var1, int var2, String var3);
    }
}

