/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.support;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class PrefixedMessageSource
implements MessageSource,
HierarchicalMessageSource {
    private String singlePrefix = "";
    private MessageSource singleDelegate;
    private Map<String, MessageSource> delegates = new LinkedHashMap<String, MessageSource>(2);
    private MessageSource parent;

    public void setParentMessageSource(MessageSource parent) {
        this.parent = parent;
        this.setupParentMessageSource(parent);
    }

    private void setupParentMessageSource(MessageSource parent) {
        for (MessageSource delegate : this.delegates.values()) {
            if (!(delegate instanceof HierarchicalMessageSource)) continue;
            ((HierarchicalMessageSource)delegate).setParentMessageSource(parent);
        }
    }

    public MessageSource getParentMessageSource() {
        return this.parent;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String result;
        if (this.delegates == null || this.delegates.isEmpty()) {
            return defaultMessage;
        }
        for (Map.Entry<String, MessageSource> me : this.delegates.entrySet()) {
            String result2;
            String prefix = me.getKey();
            MessageSource delegate = me.getValue();
            if (prefix == null || delegate == null || prefix.length() >= 1 && !code.startsWith(prefix)) continue;
            if (prefix.length() > 0) {
                code = code.substring(prefix.length());
            }
            if ((result2 = delegate.getMessage(code, args, null, locale)) == null) continue;
            return result2;
        }
        if (this.singleDelegate != null && (result = this.singleDelegate.getMessage(code, args, null, locale)) != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.getMessage(code, args, defaultMessage, locale);
        }
        return defaultMessage;
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        String result;
        if (this.delegates == null || this.delegates.isEmpty()) {
            throw new NoSuchMessageException(code, locale);
        }
        for (Map.Entry<String, MessageSource> me : this.delegates.entrySet()) {
            String result2;
            String prefix = me.getKey();
            MessageSource delegate = me.getValue();
            if (prefix == null || delegate == null || prefix.length() >= 1 && !code.startsWith(prefix)) continue;
            if (prefix.length() > 0) {
                code = code.substring(prefix.length());
            }
            if ((result2 = delegate.getMessage(code, args, null, locale)) == null) continue;
            return result2;
        }
        if (this.singleDelegate != null && (result = this.singleDelegate.getMessage(code, args, null, locale)) != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.getMessage(code, args, locale);
        }
        throw new NoSuchMessageException(code, locale);
    }

    public String getMessage(final MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        if (this.delegates == null || this.delegates.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, MessageSource> me : this.delegates.entrySet()) {
            String prefix = me.getKey();
            MessageSource delegate = me.getValue();
            String[] origCodes = resolvable.getCodes();
            final String[] codes = new String[origCodes != null ? origCodes.length : 0];
            for (int i = 0; i < codes.length; ++i) {
                String code = origCodes[i];
                if (prefix == null || delegate == null || prefix.length() >= 1 && !code.startsWith(prefix)) continue;
                if (prefix.length() > 0) {
                    code = code.substring(prefix.length());
                }
                codes[i] = code;
            }
            try {
                String result = delegate.getMessage(new MessageSourceResolvable(){

                    public String getDefaultMessage() {
                        return resolvable.getDefaultMessage();
                    }

                    public String[] getCodes() {
                        return codes;
                    }

                    public Object[] getArguments() {
                        return resolvable.getArguments();
                    }
                }, locale);
                if (result == null) continue;
                return result;
            }
            catch (NoSuchMessageException noSuchMessageException) {
            }
        }
        return null;
    }

    public String getPrefix() {
        return this.singlePrefix;
    }

    public void setPrefix(String prefix) {
        this.singlePrefix = prefix;
        this.delegates.put(prefix, this.singleDelegate);
    }

    public MessageSource getDelegate() {
        return this.singleDelegate;
    }

    public void setDelegate(MessageSource delegate) {
        this.singleDelegate = delegate;
        this.delegates.put(this.singlePrefix, delegate);
        if (this.parent != null) {
            this.setupParentMessageSource(this.parent);
        }
    }

    public Map<String, MessageSource> getDelegates() {
        return this.delegates;
    }

    public void setDelegates(Map<String, MessageSource> delegates) {
        this.delegates = new LinkedHashMap<String, MessageSource>(delegates);
        if (this.singleDelegate != null) {
            this.delegates.put(this.singlePrefix, this.singleDelegate);
        }
        if (this.parent != null) {
            this.setupParentMessageSource(this.parent);
        }
    }
}

