/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;

public final class ApplicationContextUtils {
    public static void traceBeanNames(ApplicationContext ctx, Logger log) {
        if (log.isTraceEnabled()) {
            String[] beanNames = ctx.getBeanDefinitionNames();
            String names = Arrays.stream(beanNames).sorted(Comparator.comparing(Function.identity(), String.CASE_INSENSITIVE_ORDER)).collect(Collectors.joining(",\n\t"));
            log.trace("Beans available in {}: [\n{\n}", (Object)ctx, (Object)names);
        }
    }
}

