/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.util.AbstractList;
import java.util.Collection;
import net.solarnetwork.util.ByteConsumer;
import net.solarnetwork.util.ByteOrderedIterable;

public class ByteList
extends AbstractList<Byte>
implements ByteOrderedIterable,
Cloneable {
    public static final int DEFAULT_CAPACITY = 16;
    public static final byte DEFAULT_NULL_VALUE = 0;
    private final byte nullValue;
    private byte[] data;
    private int size;

    public ByteList() {
        this(16, 0);
    }

    public ByteList(int capacity) {
        this(capacity, 0);
    }

    public ByteList(int capacity, byte nullValue) {
        this.data = new byte[capacity];
        this.size = 0;
        this.nullValue = nullValue;
    }

    public ByteList(byte[] values) {
        this(values, 0);
    }

    public ByteList(byte[] values, byte nullValue) {
        this.data = (byte[])values.clone();
        this.size = values.length;
        this.nullValue = nullValue;
    }

    public ByteList(Collection<Byte> other) {
        if (other instanceof ByteList) {
            ByteList l = (ByteList)other;
            this.data = (byte[])l.data.clone();
            this.size = l.size;
            this.nullValue = l.nullValue;
        } else {
            this.data = new byte[other.size()];
            this.size = 0;
            this.nullValue = 0;
            for (Byte b : other) {
                if (b == null) {
                    this.add(this.nullValue);
                    continue;
                }
                this.add((byte)b);
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return new ByteList(this.data, this.nullValue);
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.data.length) {
            int newCap = Math.max(this.data.length << 1, capacity);
            byte[] tmp = new byte[newCap];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
    }

    @Override
    public void forEachOrdered(ByteConsumer action) {
        this.forEachOrdered(0, this.size, action);
    }

    @Override
    public void forEachOrdered(int min, int max, ByteConsumer action) {
        if (min < 0 || min > this.size) {
            throw new ArrayIndexOutOfBoundsException(min);
        }
        if (max < 0 || max > this.size) {
            throw new ArrayIndexOutOfBoundsException(max);
        }
        for (int i = min; i < max; ++i) {
            action.accept(this.data[i]);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getCapacity() {
        return this.data.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Byte get(int index) {
        return this.getValue(index);
    }

    public byte getValue(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public byte getNullValue() {
        return this.nullValue;
    }

    @Override
    public boolean add(Byte e) {
        return this.add(e == null ? this.nullValue : e);
    }

    @Override
    public boolean add(byte b) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = b;
        return true;
    }

    @Override
    public void add(int index, Byte element) {
        this.addAll(index, new byte[]{element == null ? this.nullValue : element}, 0, 1);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Byte> c) {
        if (c instanceof ByteList) {
            return this.addAll(index, ((ByteList)c).data, 0, c.size());
        }
        byte[] vals = new byte[c.size()];
        int i = 0;
        for (Byte by : c) {
            vals[i++] = by == null ? this.nullValue : by;
        }
        return this.addAll(index, vals, 0, vals.length);
    }

    public boolean addAll(int index, byte[] src, int srcPos, int length) {
        this.ensureCapacity(this.size + length);
        System.arraycopy(this.data, index, this.data, index + length, length);
        System.arraycopy(src, srcPos, this.data, index, length);
        this.size += length;
        return true;
    }

    public void addAll(byte[] src) {
        this.add(src, 0, src.length);
    }

    public void add(byte[] src, int srcPos, int length) {
        this.ensureCapacity(this.size + length);
        System.arraycopy(src, srcPos, this.data, this.size, length);
        this.size += length;
    }

    public byte[] toArrayValue() {
        return this.slice(0, this.size);
    }

    public byte[] slice(int index, int length) {
        byte[] dest = new byte[length];
        this.copy(index, dest, 0, length);
        return dest;
    }

    public void copy(int index, byte[] dest, int destPos, int length) {
        if (length == 0) {
            return;
        }
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        System.arraycopy(this.data, index, dest, destPos, length);
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public Byte remove(int index) {
        byte b = this.get(index);
        this.remove(index, 1);
        return b;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.remove(fromIndex, toIndex - fromIndex);
    }

    public void remove(int index, int length) {
        if (length == 0) {
            return;
        }
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (index == 0) {
            System.arraycopy(this.data, length, this.data, 0, this.size - length);
        } else if (this.size - length != index) {
            System.arraycopy(this.data, index + length, this.data, index, this.size - (index + length));
        }
        this.size -= length;
    }
}

