/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.util.concurrent.TimeUnit;

public class CachedResult<T> {
    private final long created;
    private final long expires;
    private final T result;

    public CachedResult(T result, long ttl, TimeUnit unit) {
        this(result, System.currentTimeMillis(), ttl, unit);
    }

    public CachedResult(T result, long created, long ttl, TimeUnit unit) {
        this.result = result;
        this.created = created;
        this.expires = created + unit.toMillis(ttl);
    }

    public boolean isValid() {
        return System.currentTimeMillis() < this.expires;
    }

    public long getCreated() {
        return this.created;
    }

    public long getExpires() {
        return this.expires;
    }

    public T getResult() {
        return this.result;
    }
}

