/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Pattern;
import net.solarnetwork.util.IntOrderedIterable;
import net.solarnetwork.util.IntRange;
import net.solarnetwork.util.NumberUtils;

public final class CollectionUtils {
    public static final Pattern SENSITIVE_NAME_PATTERN = Pattern.compile("(?:secret|pass)", 2);

    public static List<IntRange> coveringIntRanges(SortedSet<Integer> set, int maxRangeLength) {
        IntRange last;
        if (maxRangeLength < 1) {
            throw new IllegalArgumentException("Max range length must be greater than 0.");
        }
        if (set == null) {
            return null;
        }
        ArrayList<IntRange> result = new ArrayList<IntRange>();
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        if (set instanceof IntOrderedIterable) {
            int min = set.first();
            int[] meta = new int[]{min, min};
            ((IntOrderedIterable)((Object)set)).forEachOrdered(v -> {
                int d = v - meta[0];
                if (d >= maxRangeLength) {
                    result.add(IntRange.rangeOf(meta[0], meta[1]));
                    meta[0] = v;
                    meta[1] = v;
                } else {
                    meta[1] = v;
                }
            });
            last = IntRange.rangeOf(meta[0], meta[1]);
        } else {
            int v2;
            int a;
            Iterator itr = set.iterator();
            int b = a = (v2 = ((Integer)itr.next()).intValue());
            while (itr.hasNext()) {
                v2 = (Integer)itr.next();
                int d = v2 - a;
                if (d >= maxRangeLength) {
                    result.add(IntRange.rangeOf(a, b));
                    a = v2;
                    b = v2;
                    continue;
                }
                b = v2;
            }
            last = IntRange.rangeOf(a, b);
        }
        if (result.isEmpty() || !((IntRange)result.get(result.size() - 1)).equals(last)) {
            result.add(last);
        }
        return result;
    }

    public static <K, V> Map<K, V> mapForDictionary(Dictionary<K, V> dict) {
        if (dict == null) {
            return null;
        }
        HashMap<K, V> result = new HashMap<K, V>(dict.size());
        Enumeration<K> keyEnum = dict.keys();
        while (keyEnum.hasMoreElements()) {
            K key = keyEnum.nextElement();
            if (key == null) continue;
            result.put(key, dict.get(key));
        }
        return result;
    }

    public static <K, V> Dictionary<K, V> dictionaryForMap(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        return new Hashtable<K, V>(map);
    }

    public static String getMapString(String key, Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object s = map.get(key);
        if (s == null) {
            return null;
        }
        if (s instanceof String) {
            return (String)s;
        }
        return s.toString();
    }

    public static Short getMapShort(String key, Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object n = map.get(key);
        if (n == null) {
            return null;
        }
        if (n instanceof Short) {
            return (Short)n;
        }
        if (n instanceof Number) {
            return ((Number)n).shortValue();
        }
        try {
            return Short.valueOf(n.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer getMapInteger(String key, Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object n = map.get(key);
        if (n == null) {
            return null;
        }
        if (n instanceof Integer) {
            return (Integer)n;
        }
        if (n instanceof Number) {
            return ((Number)n).intValue();
        }
        try {
            return Integer.valueOf(n.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long getMapLong(String key, Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object n = map.get(key);
        if (n == null) {
            return null;
        }
        if (n instanceof Long) {
            return (Long)n;
        }
        if (n instanceof Number) {
            return ((Number)n).longValue();
        }
        try {
            return Long.valueOf(n.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Float getMapFloat(String key, Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object n = map.get(key);
        if (n == null) {
            return null;
        }
        if (n instanceof Float) {
            return (Float)n;
        }
        if (n instanceof Number) {
            return Float.valueOf(((Number)n).floatValue());
        }
        try {
            return Float.valueOf(n.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Double getMapDouble(String key, Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object n = map.get(key);
        if (n == null) {
            return null;
        }
        if (n instanceof Double) {
            return (Double)n;
        }
        if (n instanceof Number) {
            return ((Number)n).doubleValue();
        }
        try {
            return Double.valueOf(n.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static BigDecimal getMapBigDecimal(String key, Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object n = map.get(key);
        if (n == null) {
            return null;
        }
        if (n instanceof Number) {
            return NumberUtils.bigDecimalForNumber((Number)n);
        }
        try {
            return new BigDecimal(n.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static BigInteger getMapBigInteger(String key, Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object n = map.get(key);
        if (n == null) {
            return null;
        }
        if (n instanceof Number) {
            return NumberUtils.bigIntegerForNumber((Number)n);
        }
        try {
            return new BigInteger(n.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Set<String> sensitiveNamesToMask(Set<String> set) {
        return CollectionUtils.valuesMatching(set, SENSITIVE_NAME_PATTERN);
    }

    public static Set<String> valuesMatching(Set<String> set, Pattern pattern) {
        if (set == null || set.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = null;
        for (String n : set) {
            if (n == null || n.isEmpty() || !pattern.matcher(n).find()) continue;
            if (result == null) {
                result = new HashSet<String>(4, 0.9f);
            }
            result.add(n);
        }
        return result == null ? Collections.emptySet() : result;
    }
}

