/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.ClassUtils;

public class MapBeanProxy
implements InvocationHandler {
    public static final Pattern GETTER_REGEX = Pattern.compile("(?:get|is)([A-Z][a-zA-Z0-9_]*)");
    public static final Pattern SETTER_REGEX = Pattern.compile("set([A-Z][a-zA-Z0-9_]*)");
    private final Map<String, ?> data;
    private final boolean readOnly;

    public MapBeanProxy(Map<String, ?> data) {
        this(data, true);
    }

    public MapBeanProxy(Map<String, ?> data, boolean readOnly) {
        this.data = data != null ? data : (readOnly ? Collections.emptyMap() : new LinkedHashMap());
        this.readOnly = readOnly;
    }

    public static <T> T createProxy(MapBeanProxy bean, Class<?> ... interfaces) {
        if (interfaces == null) {
            interfaces = ClassUtils.getAllInterfaces((Object)bean);
        }
        Object proxy = Proxy.newProxyInstance(bean.getClass().getClassLoader(), interfaces, (InvocationHandler)bean);
        return (T)proxy;
    }

    public static <T> T createProxy(MapBeanProxy bean, ClassLoader classLoader, Class<?> ... interfaces) {
        if (interfaces == null) {
            interfaces = ClassUtils.getAllInterfaces((Object)bean);
        }
        if (classLoader == null) {
            classLoader = bean.getClass().getClassLoader();
        }
        return (T)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)bean);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Object result = null;
        if (args == null) {
            result = this.get(this.keyForMethodName(GETTER_REGEX, methodName));
            if (result == null) {
                try {
                    Method delegateMethod = this.getClass().getMethod(methodName, method.getParameterTypes());
                    result = delegateMethod.invoke((Object)this, args);
                }
                catch (Exception exception) {}
            }
        } else if (args.length == 1 && !this.readOnly) {
            this.set(this.keyForMethodName(SETTER_REGEX, methodName), args[0]);
        }
        return result;
    }

    private String keyForMethodName(Pattern pat, String methodName) {
        String k;
        Matcher m = pat.matcher(methodName);
        String string = k = m.matches() ? m.group(1) : null;
        if (k != null) {
            if (k.length() < 2) {
                return k.toLowerCase();
            }
            k = k.substring(0, 1).toLowerCase() + k.substring(1);
        }
        return k;
    }

    private Object get(String key) {
        if (key == null) {
            return null;
        }
        return this.data.get(key);
    }

    private void set(String key, Object val) {
        if (key == null) {
            return;
        }
        this.data.put(key, val);
    }

    public Map<String, ?> getData() {
        return this.data;
    }
}

