/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.solarnetwork.util.NumberUtils;
import net.solarnetwork.util.SearchFilter;

public class MapPathMatcher {
    private final Map<String, ?> root;

    public MapPathMatcher(Map<String, ?> map) {
        this.root = map;
    }

    public static boolean matches(Map<String, ?> map, String filterText) {
        return new MapPathMatcher(map).matches(filterText);
    }

    public static boolean matches(Map<String, ?> map, SearchFilter filter) {
        return new MapPathMatcher(map).matches(filter);
    }

    public boolean matches(String filterText) {
        if (this.root == null) {
            return false;
        }
        return this.matches(SearchFilter.forLDAPSearchFilterString(filterText));
    }

    public boolean matches(SearchFilter filter) {
        if (this.root == null) {
            return false;
        }
        Evaluator eval = new Evaluator();
        return eval.evaluateFilter(this.root, filter);
    }

    private static boolean handleCallbackValue(Object value, List<String> currPath, EvalCallback callback) {
        if (value != null && value.getClass().isArray()) {
            Object[] valueArray = (Object[])value;
            int len = valueArray.length;
            for (int j = 0; j < len; ++j) {
                if (callback.isMatch(currPath, valueArray[j])) continue;
                return false;
            }
        } else if (value instanceof Iterable) {
            Iterable valueCollection = (Iterable)value;
            for (Object colValue : valueCollection) {
                if (callback.isMatch(currPath, colValue)) continue;
                return false;
            }
        } else if (!callback.isMatch(currPath, value)) {
            return false;
        }
        return true;
    }

    private static boolean walkObjectPathValues(Map<String, ?> obj, List<String> pathTokens, final EvalCallback callback) {
        String pathToken = null;
        final ArrayList<String> currPath = new ArrayList<String>();
        String prop = null;
        Object val = null;
        int currPathIdx = -1;
        int end = pathTokens.size() - 1;
        for (int i = 0; i <= end; ++i) {
            pathToken = pathTokens.get(i);
            if (pathToken.length() < 1) continue;
            currPath.add(pathToken);
            if ("*".equals(pathToken) && i == end) {
                currPathIdx = currPath.size() - 1;
                for (Map.Entry<String, ?> me : obj.entrySet()) {
                    currPath.set(currPathIdx, me.getKey());
                    val = me.getValue();
                    if (MapPathMatcher.handleCallbackValue(val, currPath, callback)) continue;
                    return false;
                }
                continue;
            }
            if ("**".equals(pathToken) && i < end) {
                currPathIdx = currPath.size() - 1;
                for (Map.Entry<String, ?> me : obj.entrySet()) {
                    currPath.set(currPathIdx, me.getKey());
                    prop = me.getKey();
                    val = me.getValue();
                    if (!(prop.equals(pathTokens.get(i + 1)) && val != null && (!(val instanceof Map) && i + 1 == end || val instanceof Map && i + 1 < end) ? (!(val instanceof Map) && i + 1 == end ? !MapPathMatcher.handleCallbackValue(val, currPath, callback) : !MapPathMatcher.walkObjectPathValues(val, pathTokens.subList(i + 2, pathTokens.size()), new EvalCallback(){

                        @Override
                        public boolean isMatch(List<String> nestedPath, Object nestedVal) {
                            ArrayList<String> p = new ArrayList<String>(currPath);
                            p.addAll(nestedPath);
                            return callback.isMatch(p, nestedVal);
                        }
                    })) : (val instanceof Map ? !MapPathMatcher.walkObjectPathValues(val, pathTokens.subList(i, pathTokens.size()), new EvalCallback(){

                        @Override
                        public boolean isMatch(List<String> nestedPath, Object nestedVal) {
                            ArrayList<String> p = new ArrayList<String>(currPath);
                            p.addAll(nestedPath);
                            return callback.isMatch(p, nestedVal);
                        }
                    }) : "*".equals(pathTokens.get(i + 1)) && !MapPathMatcher.handleCallbackValue(val, currPath, callback)))) continue;
                    return false;
                }
                break;
            }
            if (i == end) {
                if (MapPathMatcher.handleCallbackValue(obj.get(pathToken), currPath, callback)) continue;
                return false;
            }
            if (!(obj.get(pathToken) instanceof Map)) break;
            obj = (Map)obj.get(pathToken);
        }
        return true;
    }

    private static interface EvalCallback {
        public boolean isMatch(List<String> var1, Object var2);
    }

    private static class Evaluator {
        private final List<StackObj> logicStack = new ArrayList<StackObj>();
        private int stackIdx = -1;
        private int logicStackSatisfiedIdx = -1;
        private SearchFilter.LogicOperator currLogicOp = SearchFilter.LogicOperator.AND;
        private boolean foundMatch = false;

        private Evaluator() {
        }

        private boolean shortCircuitIfPossible(boolean match) {
            boolean keepWalking = true;
            if (this.currLogicOp == SearchFilter.LogicOperator.AND) {
                if (!match) {
                    if (this.stackIdx >= 0) {
                        this.logicStack.get(this.stackIdx).result = false;
                    }
                    if (this.stackIdx < 1) {
                        this.foundMatch = false;
                        keepWalking = false;
                    } else {
                        this.logicStackSatisfiedIdx = this.stackIdx;
                    }
                } else if (this.stackIdx < 0) {
                    this.foundMatch = true;
                } else {
                    this.logicStack.get(this.stackIdx).result = true;
                }
            } else if (this.currLogicOp == SearchFilter.LogicOperator.OR) {
                if (match) {
                    if (this.stackIdx >= 0) {
                        this.logicStack.get(this.stackIdx).result = true;
                    }
                    if (this.stackIdx < 1) {
                        this.foundMatch = true;
                        keepWalking = false;
                    } else {
                        this.logicStackSatisfiedIdx = this.stackIdx;
                    }
                }
            } else if (this.currLogicOp == SearchFilter.LogicOperator.NOT) {
                if (this.stackIdx >= 0) {
                    this.logicStack.get(this.stackIdx).result = !match;
                }
                if (this.stackIdx < 1) {
                    this.foundMatch = !match;
                    keepWalking = false;
                }
            }
            return !keepWalking;
        }

        private boolean evaluateFilter(final Map<String, ?> obj, SearchFilter filter) {
            filter.walk(new SearchFilter.VisitorCallback(){

                @Override
                public boolean visit(final SearchFilter node, SearchFilter parent) {
                    boolean match = false;
                    if (parent != null && parent != ((StackObj)logicStack.get(stackIdx)).node) {
                        while (stackIdx >= 0) {
                            StackObj o = (StackObj)logicStack.get(stackIdx);
                            if (stackIdx + 1 < logicStack.size()) {
                                currLogicOp = o.op;
                                if (this.shortCircuitIfPossible(((StackObj)logicStack.get(stackIdx + 1)).result)) {
                                    return false;
                                }
                            }
                            if (o.node == parent) break;
                            stackIdx -= 1;
                        }
                        while (logicStack.size() > stackIdx + 1) {
                            logicStack.remove(logicStack.size() - 1);
                        }
                        if (stackIdx < 0) {
                            return false;
                        }
                        if (logicStackSatisfiedIdx > stackIdx) {
                            logicStackSatisfiedIdx = -1;
                        }
                    }
                    if (node.hasNestedFilter()) {
                        logicStack.add(new StackObj(node.getLogicOperator(), false, node));
                        currLogicOp = node.getLogicOperator();
                        stackIdx += 1;
                    } else if (logicStackSatisfiedIdx == -1) {
                        for (final Map.Entry<String, ?> me : node.filter.entrySet()) {
                            boolean r = MapPathMatcher.walkObjectPathValues(obj, Arrays.asList(me.getKey().split("/")), new EvalCallback(){

                                private boolean isComparableOp(SearchFilter.CompareOperator op) {
                                    return op == SearchFilter.CompareOperator.LESS_THAN || op == SearchFilter.CompareOperator.LESS_THAN_EQUAL || op == SearchFilter.CompareOperator.GREATER_THAN || op == SearchFilter.CompareOperator.GREATER_THAN_EQUAL;
                                }

                                private boolean matchAsComparable(Object objValue, Object pathValue, SearchFilter.CompareOperator op) {
                                    Object l = null;
                                    Object r = null;
                                    try {
                                        BigDecimal objNumber = NumberUtils.bigDecimalForNumber((Number)objValue);
                                        BigDecimal pathNumber = new BigDecimal(pathValue.toString());
                                        l = objNumber;
                                        r = pathNumber;
                                    }
                                    catch (NumberFormatException e) {
                                        l = objValue.toString();
                                        r = pathValue.toString();
                                    }
                                    if (l != null && r != null) {
                                        switch (op) {
                                            case LESS_THAN: {
                                                return l.compareTo(r) < 0;
                                            }
                                            case LESS_THAN_EQUAL: {
                                                return l.compareTo(r) <= 0;
                                            }
                                            case GREATER_THAN: {
                                                return l.compareTo(r) > 0;
                                            }
                                            case GREATER_THAN_EQUAL: {
                                                return l.compareTo(r) >= 0;
                                            }
                                        }
                                    }
                                    return false;
                                }

                                @Override
                                public boolean isMatch(List<String> currPath, Object value) {
                                    boolean match = false;
                                    if (node.getCompareOperator() == SearchFilter.CompareOperator.EQUAL) {
                                        if (value != null && value.equals(me.getValue())) {
                                            match = true;
                                        }
                                    } else if (node.getCompareOperator() == SearchFilter.CompareOperator.APPROX) {
                                        if (value != null && value.toString().matches(me.getValue().toString())) {
                                            match = true;
                                        }
                                    } else if (this.isComparableOp(node.getCompareOperator()) && value != null && this.matchAsComparable(value, me.getValue(), node.getCompareOperator())) {
                                        match = true;
                                    }
                                    return !match;
                                }
                            });
                            match = !r;
                            if (!this.shortCircuitIfPossible(match)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            });
            if (this.logicStack.size() > 0) {
                this.foundMatch = this.logicStack.get(this.stackIdx).result;
                for (int i = this.stackIdx - 1; i >= 0; --i) {
                    if (this.logicStack.get(i).op != SearchFilter.LogicOperator.NOT) continue;
                    this.foundMatch = !this.foundMatch;
                }
            }
            return this.foundMatch;
        }
    }

    private static class StackObj {
        private final SearchFilter.LogicOperator op;
        private final SearchFilter node;
        private boolean result;

        private StackObj(SearchFilter.LogicOperator op, boolean result, SearchFilter node) {
            this.op = op;
            this.result = result;
            this.node = node;
        }
    }
}

