/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.util.Collection;

public final class ObjectUtils {
    public static <T> T requireNonNullArgument(T arg, String argumentName) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("The %s argument must not be null.", argumentName));
        }
        return arg;
    }

    public static <T> T[] requireNonEmptyArgument(T[] arg, String argumentName) {
        if (arg == null || arg.length < 1) {
            throw new IllegalArgumentException(String.format("The %s argument must not be empty.", argumentName));
        }
        return arg;
    }

    public static <T extends Collection<?>> T requireNonEmptyArgument(T arg, String argumentName) {
        if (arg == null || arg.size() < 1) {
            throw new IllegalArgumentException(String.format("The %s argument must not be empty.", argumentName));
        }
        return arg;
    }
}

