/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.util.concurrent.atomic.AtomicLongArray;
import org.slf4j.Logger;

public class StatCounter {
    private final Logger log;
    private final String name;
    private final Stat[] baseStats;
    private final Stat[] stats;
    private final AtomicLongArray counts;
    private int logFrequency;
    private String uid;

    public StatCounter(String name, String uid, Logger log, int logFrequency, Stat[] baseStats) {
        this(name, uid, log, logFrequency, baseStats, null);
    }

    public StatCounter(String name, String uid, Stat[] baseStats, Stat[] stats) {
        this(name, uid, null, 0, baseStats, stats);
    }

    public StatCounter(String name, String uid, Logger log, int logFrequency, Stat[] baseStats, Stat[] stats) {
        if (name == null) {
            throw new IllegalArgumentException("The name argument must not be null.");
        }
        this.name = name;
        if (uid == null) {
            throw new IllegalArgumentException("The uid argument must not be null.");
        }
        this.uid = uid;
        this.log = log;
        this.logFrequency = logFrequency;
        if (baseStats == null) {
            throw new IllegalArgumentException("The baseStats argument must not be null.");
        }
        this.baseStats = baseStats;
        if (stats != null && stats.getClass().getComponentType().isAssignableFrom(baseStats.getClass().getComponentType())) {
            throw new IllegalArgumentException("The stats type cannot be assignable from the baseStats type.");
        }
        this.stats = stats;
        this.counts = new AtomicLongArray(baseStats.length + (stats != null ? stats.length : 0));
    }

    public String toString() {
        Stat[] s;
        StringBuilder buf = new StringBuilder(this.name);
        buf.append(" stats {\n");
        for (Stat c : s = this.stats != null ? this.stats : this.baseStats) {
            buf.append(String.format("%30s: %d\n", c.getDescription(), this.get(c)));
        }
        buf.append("}");
        return buf.toString();
    }

    public int getLogFrequency() {
        return this.logFrequency;
    }

    public void setLogFrequency(int logFrequency) {
        this.logFrequency = logFrequency;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    private int countStatIndex(Stat stat) {
        if (stat == null) {
            throw new IllegalArgumentException("The stat argument must not be null.");
        }
        int idx = stat.getIndex();
        Class<?> clazz = stat.getClass();
        if (this.stats != null && clazz.isAssignableFrom(this.stats.getClass().getComponentType())) {
            idx += this.baseStats.length;
        } else if (!clazz.isAssignableFrom(this.baseStats.getClass().getComponentType())) {
            throw new IllegalArgumentException("The stat argument type is not assigable to either baseStats or stats.");
        }
        return idx;
    }

    public long get(Stat stat) {
        return this.counts.get(this.countStatIndex(stat));
    }

    private void log(Stat stat, long count) {
        String uid = this.getUid();
        if (uid != null && !uid.isEmpty()) {
            this.log.info("{} {} {}: {}", new Object[]{this.name, uid, stat.getDescription(), count});
        } else {
            this.log.info("{} {}: {}", new Object[]{this.name, stat.getDescription(), count});
        }
    }

    public long incrementAndGet(Stat stat) {
        return this.incrementAndGet(stat, false);
    }

    public long incrementAndGet(Stat stat, boolean quiet) {
        long c = this.counts.incrementAndGet(this.countStatIndex(stat));
        if (!quiet && this.log.isInfoEnabled() && c % (long)this.logFrequency == 0L) {
            this.log(stat, c);
        }
        return c;
    }

    public long addAndGet(Stat stat, long count) {
        return this.addAndGet(stat, count, false);
    }

    public long addAndGet(Stat stat, long count, boolean quiet) {
        long c = this.counts.addAndGet(this.countStatIndex(stat), count);
        if (!quiet && this.log.isInfoEnabled() && c % (long)this.logFrequency == 0L) {
            this.log(stat, c);
        }
        return c;
    }

    public static interface Stat {
        public int getIndex();

        public String getDescription();
    }
}

