/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public final class StringMerger {
    private static final Logger LOG = LoggerFactory.getLogger(StringMerger.class);
    private static final Pattern MERGE_VAR_PAT = Pattern.compile("\\$\\{([^}]+)\\}");

    private StringMerger() {
    }

    public static String mergeResource(Resource resource, Object data) throws IOException {
        return StringMerger.mergeResource(resource, data, "");
    }

    public static String mergeResource(Resource resource, Object data, String nullValue) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Merging " + resource.getFilename() + " with " + data);
        }
        try (InputStream in = resource.getInputStream();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                StringBuilder buf = new StringBuilder();
                String oneLine = null;
                while ((oneLine = reader.readLine()) != null) {
                    StringMerger.mergeString(oneLine, data, nullValue, buf);
                    buf.append("\n");
                }
                string = buf.toString();
            }
            return string;
        }
    }

    public static String merge(String filePath, Object data) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Merging " + filePath + " with " + data);
        }
        try (BufferedReader in = new BufferedReader(new FileReader(filePath));){
            StringBuilder buf = new StringBuilder();
            String oneLine = null;
            while ((oneLine = in.readLine()) != null) {
                StringMerger.mergeString(oneLine, data, "", buf);
                buf.append("\n");
            }
            String string = buf.toString();
            return string;
        }
    }

    public static String mergeString(String src, String nullValue, Object data) {
        StringBuilder buf = new StringBuilder();
        StringMerger.mergeString(src, data, nullValue, buf);
        return buf.toString();
    }

    public static void mergeString(String src, Object data, String nullValue, StringBuilder buf) {
        Matcher matcher = MERGE_VAR_PAT.matcher(src);
        if (!matcher.find()) {
            buf.append(src);
        } else {
            int endLastMatchIdx = 0;
            do {
                MatchResult matchResult = matcher.toMatchResult();
                buf.append(src.substring(endLastMatchIdx, matchResult.start()));
                if (data == null) continue;
                int s = matchResult.start(1);
                int e = matchResult.end(1);
                if (s > -1 && e > -1) {
                    Object o;
                    String varName = src.substring(s, e);
                    if (data instanceof Map) {
                        o = null;
                        int sepIdx = varName.indexOf(46);
                        if (sepIdx > 0) {
                            String varName2 = varName.substring(sepIdx + 1);
                            o = ((Map)data).get(varName = varName.substring(0, sepIdx));
                            if (o != null) {
                                try {
                                    o = PropertyUtils.getProperty((Object)o, (String)varName2);
                                }
                                catch (Exception e2) {
                                    LOG.warn("Exception getting property '" + varName2 + "' out of " + o.getClass() + ": " + e2);
                                }
                            }
                        } else {
                            o = ((Map)data).get(varName);
                        }
                        if (o == null || String.class.isAssignableFrom(o.getClass()) && !StringUtils.hasText((String)o.toString())) {
                            buf.append(nullValue);
                        } else {
                            buf.append(o);
                        }
                    } else {
                        try {
                            o = PropertyUtils.getProperty((Object)data, (String)varName);
                            if (o == null || String.class.isAssignableFrom(o.getClass()) && !StringUtils.hasText((String)o.toString())) {
                                buf.append(nullValue);
                            } else {
                                buf.append(o);
                            }
                        }
                        catch (Exception ex) {
                            LOG.warn("Exception getting property '" + varName + "' out of " + data.getClass() + ": " + ex);
                            buf.append(nullValue);
                        }
                    }
                }
                endLastMatchIdx = matchResult.end();
            } while (matcher.find());
            if (endLastMatchIdx < src.length()) {
                buf.append(src.substring(endLastMatchIdx));
            }
        }
    }
}

