/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.solarnetwork.domain.KeyValuePair;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public final class StringUtils {
    public static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    public static Pattern INTEGER_PATTERN = Pattern.compile("[+-]?\\d+");
    public static Pattern DECIMAL_PATTERN = Pattern.compile("[+-]?\\d+(\\.\\d+)?([Ee][+-]?\\d+)?");
    private static final SecureRandom rng = new SecureRandom();
    public static final Pattern DIGEST_PREFIX_PATTERN = Pattern.compile("\\{(\\w+)-?((?<=-)\\d+)?\\}(.*)");
    public static final Pattern NOT_SIMPLE_ID_CHARACTER_PATTERN = Pattern.compile("[^a-zA-Z0-9_]+");
    public static final Pattern UNDERSCORE_PREFIX_OR_SUFFIX = Pattern.compile("(^_+|_+$)");

    private StringUtils() {
    }

    public static String expandTemplateString(String source, Map<String, ?> variables) {
        if (source == null) {
            return null;
        }
        if (source.indexOf(123) == -1) {
            return source;
        }
        if (source.indexOf(58) != -1) {
            source = StringUtils.sanitizeVariableTemplate(source);
        }
        if (variables == null) {
            variables = Collections.emptyMap();
        }
        Matcher matcher = NAMES_PATTERN.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group(1);
            Object variableValue = StringUtils.getVariableValue(match, variables);
            String variableValueString = StringUtils.getVariableValueAsString(variableValue);
            String replacement = Matcher.quoteReplacement(variableValueString);
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String sanitizeVariableTemplate(String source) {
        int level = 0;
        StringBuilder sb = new StringBuilder();
        for (char c : source.toCharArray()) {
            if (c == '{') {
                ++level;
            }
            if (c == '}') {
                --level;
            }
            if (level > 1 || level == 1 && c == '}') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static Object getVariableValue(String match, Map<String, ?> variables) {
        int colonIdx = match.indexOf(58);
        String name = colonIdx != -1 ? match.substring(0, colonIdx) : match;
        String fallback = colonIdx != -1 ? match.substring(colonIdx + 1) : null;
        Object val = variables.get(name);
        if (val == null) {
            val = fallback;
        }
        return val;
    }

    private static String getVariableValueAsString(Object variableValue) {
        return variableValue != null ? variableValue.toString() : "";
    }

    public static String commaDelimitedStringFromCollection(Collection<?> set) {
        return StringUtils.delimitedStringFromCollection(set, ",");
    }

    public static String delimitedStringFromCollection(Collection<?> set, String delim) {
        if (set == null) {
            return null;
        }
        if (delim == null) {
            delim = "";
        }
        StringBuilder buf = new StringBuilder();
        for (Object o : set) {
            if (buf.length() > 0) {
                buf.append(delim);
            }
            if (o == null) continue;
            buf.append(o.toString());
        }
        return buf.toString();
    }

    public static String delimitedStringFromMap(Map<?, ?> map) {
        return StringUtils.delimitedStringFromMap(map, "=", ",");
    }

    public static String delimitedStringFromMap(Map<?, ?> map, String keyValueDelim, String pairDelim) {
        if (map == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<?, ?> me : map.entrySet()) {
            if (buf.length() > 0) {
                buf.append(pairDelim);
            }
            if (me.getKey() != null) {
                buf.append(me.getKey().toString());
            }
            buf.append(keyValueDelim);
            if (me.getValue() == null) continue;
            buf.append(me.getValue().toString());
        }
        return buf.toString();
    }

    public static Set<String> commaDelimitedStringToSet(String list) {
        return StringUtils.delimitedStringToSet(list, ",");
    }

    public static Set<String> delimitedStringToSet(String list, String delim) {
        if (list == null || list.length() < 1) {
            return null;
        }
        String[] data = list.trim().split("\\s*" + Pattern.quote(delim) + "\\s*");
        LinkedHashSet<String> s = new LinkedHashSet<String>(data.length);
        for (String d : data) {
            s.add(d);
        }
        return s;
    }

    public static Map<String, String> commaDelimitedStringToMap(String mapping) {
        return StringUtils.delimitedStringToMap(mapping, ",", "=");
    }

    public static Map<String, String> delimitedStringToMap(String mapping, String recordDelim, String fieldDelim) {
        if (mapping == null || mapping.length() < 1) {
            return null;
        }
        String[] pairs = mapping.trim().split("\\s*" + Pattern.quote(recordDelim) + "\\s*");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Pattern fieldSplit = Pattern.compile("\\s*" + Pattern.quote(fieldDelim) + "\\s*");
        for (String pair : pairs) {
            String[] kv = fieldSplit.split(pair, 2);
            if (kv == null || kv.length != 2) continue;
            map.put(kv[0], kv[1]);
        }
        return map;
    }

    public static Pattern[] patterns(String[] expressions, int flags) {
        Pattern[] result = null;
        if (expressions != null && expressions.length > 0) {
            result = new Pattern[expressions.length];
            int len = expressions.length;
            for (int i = 0; i < len; ++i) {
                result[i] = flags == 0 ? Pattern.compile(expressions[i]) : Pattern.compile(expressions[i], flags);
            }
        }
        return result;
    }

    public static String[] expressions(Pattern[] patterns) {
        String[] results = null;
        if (patterns != null && patterns.length > 0) {
            results = new String[patterns.length];
            int len = patterns.length;
            for (int i = 0; i < len; ++i) {
                results[i] = patterns[i].pattern();
            }
        }
        return results;
    }

    public static Matcher matches(Pattern[] patterns, String text) {
        if (patterns == null || patterns.length < 0 || text == null) {
            return null;
        }
        for (Pattern pattern : patterns) {
            Matcher m = pattern.matcher(text);
            if (!m.matches()) continue;
            return m;
        }
        return null;
    }

    public static boolean parseBoolean(String s) {
        boolean result = false;
        if (s != null && (s = s.trim()).length() < 5 && ((s = s.toLowerCase()).equals("true") || s.equals("yes") || s.equals("y") || s.equals("t") || s.equals("1"))) {
            result = true;
        }
        return result;
    }

    public static final String sha256Base64Value(String propertyValue) {
        byte[] salt = new byte[8];
        rng.nextBytes(salt);
        return StringUtils.sha256Base64Value(propertyValue, salt);
    }

    public static final String sha256Base64Value(String propertyValue, byte[] salt) {
        byte[] plain;
        try {
            plain = propertyValue != null ? propertyValue.getBytes("UTF-8") : new byte[]{};
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (salt != null && salt.length > 0) {
            byte[] tmp = new byte[plain.length + salt.length];
            System.arraycopy(plain, 0, tmp, 0, plain.length);
            System.arraycopy(salt, 0, tmp, tmp.length - salt.length, salt.length);
            plain = tmp;
        }
        byte[] cipher = DigestUtils.sha256((byte[])plain);
        if (salt != null && salt.length > 0) {
            byte[] tmp = new byte[cipher.length + salt.length];
            System.arraycopy(cipher, 0, tmp, 0, cipher.length);
            System.arraycopy(salt, 0, tmp, tmp.length - salt.length, salt.length);
            cipher = tmp;
        }
        try {
            return (salt != null && salt.length > 0 ? "{SSHA-256}" : "{SHA-256}") + new String(Base64.encodeBase64((byte[])cipher, (boolean)false), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final KeyValuePair decodeBase64DigestComponents(String digest) {
        if (digest == null) {
            return null;
        }
        Matcher m = DIGEST_PREFIX_PATTERN.matcher(digest);
        if (!m.matches()) {
            return null;
        }
        String type = m.group(1).toUpperCase();
        String len = m.group(2);
        int algLen = 0;
        if (len != null) {
            algLen = Integer.parseInt(len);
        }
        byte[] salt = null;
        byte[] data = Base64.decodeBase64((String)m.group(3));
        int digestByteLen = 0;
        if (type.endsWith("SHA")) {
            digestByteLen = algLen < 2 ? 20 : algLen / 8;
        } else if (type.endsWith("MD5")) {
            digestByteLen = 16;
        }
        if (digestByteLen < data.length) {
            byte[] tmp = new byte[digestByteLen];
            System.arraycopy(data, 0, tmp, 0, digestByteLen);
            salt = new byte[data.length - digestByteLen];
            System.arraycopy(data, digestByteLen, salt, 0, salt.length);
            data = tmp;
        }
        return new KeyValuePair(Hex.encodeHexString((byte[])data), salt != null ? Hex.encodeHexString(salt) : null);
    }

    public static <K, V> Map<K, V> sha256MaskedMap(Map<K, V> map, Set<K> maskKeys) {
        Map<K, V> res = map;
        if (map != null && maskKeys != null && !map.isEmpty() && !maskKeys.isEmpty()) {
            for (K propName : maskKeys) {
                if (!map.containsKey(propName)) continue;
                LinkedHashMap<K, String> maskedMap = new LinkedHashMap<K, String>(map.size());
                for (Map.Entry<K, V> me : map.entrySet()) {
                    K key = me.getKey();
                    V val = me.getValue();
                    if (val != null && maskKeys.contains(key.toString())) {
                        String maskedVal = StringUtils.sha256Base64Value(val.toString());
                        maskedMap.put(key, maskedVal);
                        continue;
                    }
                    maskedMap.put(key, (String)val);
                }
                res = maskedMap;
                break;
            }
        }
        return res;
    }

    public static String simpleIdValue(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        String s = NOT_SIMPLE_ID_CHARACTER_PATTERN.matcher(text.trim().toLowerCase()).replaceAll("_");
        if (s.charAt(0) == '_' || s.charAt(s.length() - 1) == '_') {
            s = UNDERSCORE_PREFIX_OR_SUFFIX.matcher(s).replaceAll("");
        }
        return s;
    }

    public static int utf8length(CharSequence text) {
        return text.length() + text.codePoints().filter(cp -> cp > 127).map(cp -> cp <= 2047 ? 1 : 2).sum();
    }

    public static Number numberValue(String text) {
        if (text == null) {
            return null;
        }
        try {
            if (INTEGER_PATTERN.matcher(text).matches()) {
                return new BigInteger(text);
            }
            if (DECIMAL_PATTERN.matcher(text).matches()) {
                return new BigDecimal(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static String[] match(Pattern pattern, String text) {
        if (pattern == null || text == null) {
            return null;
        }
        Matcher m = pattern.matcher(text);
        if (m.find()) {
            int groupCount = m.groupCount();
            String[] result = new String[1 + groupCount];
            result[0] = text;
            for (int i = 1; i <= groupCount; ++i) {
                result[i] = m.group(i);
            }
            return result;
        }
        return null;
    }
}

