/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class UnionIterator<E>
implements Iterator<E> {
    private final Collection<Iterator<E>> iterators;

    public UnionIterator(Collection<Iterator<E>> iterators) {
        assert (iterators != null);
        this.iterators = new ArrayList<Iterator<Iterator<E>>>(iterators);
    }

    @Override
    public boolean hasNext() {
        Iterator<Iterator<E>> itr = this.iterators.iterator();
        while (itr.hasNext()) {
            Iterator<E> e = itr.next();
            if (e.hasNext()) {
                return true;
            }
            this.finishedIterator(e);
            itr.remove();
        }
        return false;
    }

    protected void finishedIterator(Iterator<E> itr) {
    }

    @Override
    public E next() {
        assert (this.iterators.size() > 0);
        return this.iterators.iterator().next().next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

