/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.List;
import ocpp.v201.CustomData;
import ocpp.v201.IdToken;
import ocpp.v201.OCSPRequestData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "idToken", "certificate", "iso15118CertificateHashData"})
public class AuthorizeRequest
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="idToken")
    @JsonPropertyDescription(value="Contains a case insensitive identifier to use for the authorization and the type of authorization to support multiple forms of identifiers.\r\n")
    private IdToken idToken;
    @JsonProperty(value="certificate")
    @JsonPropertyDescription(value="The X.509 certificated presented by EV and encoded in PEM format.\r\n")
    private String certificate;
    @JsonProperty(value="iso15118CertificateHashData")
    private List<OCSPRequestData> iso15118CertificateHashData;
    private static final long serialVersionUID = -3521900153192774515L;

    public AuthorizeRequest() {
    }

    public AuthorizeRequest(IdToken idToken) {
        this.idToken = idToken;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public AuthorizeRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="idToken")
    public IdToken getIdToken() {
        return this.idToken;
    }

    @JsonProperty(value="idToken")
    public void setIdToken(IdToken idToken) {
        this.idToken = idToken;
    }

    public AuthorizeRequest withIdToken(IdToken idToken) {
        this.idToken = idToken;
        return this;
    }

    @JsonProperty(value="certificate")
    public String getCertificate() {
        return this.certificate;
    }

    @JsonProperty(value="certificate")
    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public AuthorizeRequest withCertificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    @JsonProperty(value="iso15118CertificateHashData")
    public List<OCSPRequestData> getIso15118CertificateHashData() {
        return this.iso15118CertificateHashData;
    }

    @JsonProperty(value="iso15118CertificateHashData")
    public void setIso15118CertificateHashData(List<OCSPRequestData> iso15118CertificateHashData) {
        this.iso15118CertificateHashData = iso15118CertificateHashData;
    }

    public AuthorizeRequest withIso15118CertificateHashData(List<OCSPRequestData> iso15118CertificateHashData) {
        this.iso15118CertificateHashData = iso15118CertificateHashData;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(AuthorizeRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("idToken");
        sb.append('=');
        sb.append(this.idToken == null ? "<null>" : this.idToken);
        sb.append(',');
        sb.append("certificate");
        sb.append('=');
        sb.append(this.certificate == null ? "<null>" : this.certificate);
        sb.append(',');
        sb.append("iso15118CertificateHashData");
        sb.append('=');
        sb.append(this.iso15118CertificateHashData == null ? "<null>" : this.iso15118CertificateHashData);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.idToken == null ? 0 : this.idToken.hashCode());
        result = result * 31 + (this.certificate == null ? 0 : this.certificate.hashCode());
        result = result * 31 + (this.iso15118CertificateHashData == null ? 0 : this.iso15118CertificateHashData.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AuthorizeRequest)) {
            return false;
        }
        AuthorizeRequest rhs = (AuthorizeRequest)other;
        return (this.idToken == rhs.idToken || this.idToken != null && this.idToken.equals(rhs.idToken)) && (this.certificate == rhs.certificate || this.certificate != null && this.certificate.equals(rhs.certificate)) && (this.iso15118CertificateHashData == rhs.iso15118CertificateHashData || this.iso15118CertificateHashData != null && this.iso15118CertificateHashData.equals(rhs.iso15118CertificateHashData)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData));
    }
}

