/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;
import ocpp.v201.CustomData;
import ocpp.v201.RegistrationStatusEnum;
import ocpp.v201.StatusInfo;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "currentTime", "interval", "status", "statusInfo"})
public class BootNotificationResponse
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="currentTime")
    @JsonPropertyDescription(value="This contains the CSMS\u2019s current time.\r\n")
    private Instant currentTime;
    @JsonProperty(value="interval")
    @JsonPropertyDescription(value="When &lt;&lt;cmn_registrationstatusenumtype,Status&gt;&gt; is Accepted, this contains the heartbeat interval in seconds. If the CSMS returns something other than Accepted, the value of the interval field indicates the minimum wait time before sending a next BootNotification request.\r\n")
    private Integer interval;
    @JsonProperty(value="status")
    @JsonPropertyDescription(value="This contains whether the Charging Station has been registered\r\nwithin the CSMS.\r\n")
    private RegistrationStatusEnum status;
    @JsonProperty(value="statusInfo")
    @JsonPropertyDescription(value="Element providing more information about the status.\r\n")
    private StatusInfo statusInfo;
    private static final long serialVersionUID = 7190152897034048881L;

    public BootNotificationResponse() {
    }

    public BootNotificationResponse(Instant currentTime, Integer interval, RegistrationStatusEnum status) {
        this.currentTime = currentTime;
        this.interval = interval;
        this.status = status;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public BootNotificationResponse withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="currentTime")
    public Instant getCurrentTime() {
        return this.currentTime;
    }

    @JsonProperty(value="currentTime")
    public void setCurrentTime(Instant currentTime) {
        this.currentTime = currentTime;
    }

    public BootNotificationResponse withCurrentTime(Instant currentTime) {
        this.currentTime = currentTime;
        return this;
    }

    @JsonProperty(value="interval")
    public Integer getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public BootNotificationResponse withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    @JsonProperty(value="status")
    public RegistrationStatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(RegistrationStatusEnum status) {
        this.status = status;
    }

    public BootNotificationResponse withStatus(RegistrationStatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="statusInfo")
    public StatusInfo getStatusInfo() {
        return this.statusInfo;
    }

    @JsonProperty(value="statusInfo")
    public void setStatusInfo(StatusInfo statusInfo) {
        this.statusInfo = statusInfo;
    }

    public BootNotificationResponse withStatusInfo(StatusInfo statusInfo) {
        this.statusInfo = statusInfo;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(BootNotificationResponse.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("currentTime");
        sb.append('=');
        sb.append(this.currentTime == null ? "<null>" : this.currentTime);
        sb.append(',');
        sb.append("interval");
        sb.append('=');
        sb.append(this.interval == null ? "<null>" : this.interval);
        sb.append(',');
        sb.append("status");
        sb.append('=');
        sb.append(this.status == null ? "<null>" : this.status);
        sb.append(',');
        sb.append("statusInfo");
        sb.append('=');
        sb.append(this.statusInfo == null ? "<null>" : this.statusInfo);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.currentTime == null ? 0 : this.currentTime.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.interval == null ? 0 : this.interval.hashCode());
        result = result * 31 + (this.statusInfo == null ? 0 : this.statusInfo.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BootNotificationResponse)) {
            return false;
        }
        BootNotificationResponse rhs = (BootNotificationResponse)other;
        return (this.currentTime == rhs.currentTime || this.currentTime != null && this.currentTime.equals(rhs.currentTime)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.interval == rhs.interval || this.interval != null && this.interval.equals(rhs.interval)) && (this.statusInfo == rhs.statusInfo || this.statusInfo != null && this.statusInfo.equals(rhs.statusInfo)) && (this.status == rhs.status || this.status != null && this.status.equals((Object)rhs.status));
    }
}

