/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import ocpp.v201.ChargingProfileKindEnum;
import ocpp.v201.ChargingProfilePurposeEnum;
import ocpp.v201.ChargingSchedule;
import ocpp.v201.CustomData;
import ocpp.v201.RecurrencyKindEnum;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "id", "stackLevel", "chargingProfilePurpose", "chargingProfileKind", "recurrencyKind", "validFrom", "validTo", "chargingSchedule", "transactionId"})
public class ChargingProfile
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Identified_ Object. MRID. Numeric_ Identifier\r\nurn:x-enexis:ecdm:uid:1:569198\r\nId of ChargingProfile.\r\n")
    private Integer id;
    @JsonProperty(value="stackLevel")
    @JsonPropertyDescription(value="Charging_ Profile. Stack_ Level. Counter\r\nurn:x-oca:ocpp:uid:1:569230\r\nValue determining level in hierarchy stack of profiles. Higher values have precedence over lower values. Lowest level is 0.\r\n")
    private Integer stackLevel;
    @JsonProperty(value="chargingProfilePurpose")
    @JsonPropertyDescription(value="Charging_ Profile. Charging_ Profile_ Purpose. Charging_ Profile_ Purpose_ Code\r\nurn:x-oca:ocpp:uid:1:569231\r\nDefines the purpose of the schedule transferred by this profile\r\n")
    private ChargingProfilePurposeEnum chargingProfilePurpose;
    @JsonProperty(value="chargingProfileKind")
    @JsonPropertyDescription(value="Charging_ Profile. Charging_ Profile_ Kind. Charging_ Profile_ Kind_ Code\r\nurn:x-oca:ocpp:uid:1:569232\r\nIndicates the kind of schedule.\r\n")
    private ChargingProfileKindEnum chargingProfileKind;
    @JsonProperty(value="recurrencyKind")
    @JsonPropertyDescription(value="Charging_ Profile. Recurrency_ Kind. Recurrency_ Kind_ Code\r\nurn:x-oca:ocpp:uid:1:569233\r\nIndicates the start point of a recurrence.\r\n")
    private RecurrencyKindEnum recurrencyKind;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="validFrom")
    @JsonPropertyDescription(value="Charging_ Profile. Valid_ From. Date_ Time\r\nurn:x-oca:ocpp:uid:1:569234\r\nPoint in time at which the profile starts to be valid. If absent, the profile is valid as soon as it is received by the Charging Station.\r\n")
    private Instant validFrom;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="validTo")
    @JsonPropertyDescription(value="Charging_ Profile. Valid_ To. Date_ Time\r\nurn:x-oca:ocpp:uid:1:569235\r\nPoint in time at which the profile stops to be valid. If absent, the profile is valid until it is replaced by another profile.\r\n")
    private Instant validTo;
    @JsonProperty(value="chargingSchedule")
    private List<ChargingSchedule> chargingSchedule;
    @JsonProperty(value="transactionId")
    @JsonPropertyDescription(value="SHALL only be included if ChargingProfilePurpose is set to TxProfile. The transactionId is used to match the profile to a specific transaction.\r\n")
    private String transactionId;
    private static final long serialVersionUID = -3934844716390465074L;

    public ChargingProfile() {
    }

    public ChargingProfile(Integer id, Integer stackLevel, ChargingProfilePurposeEnum chargingProfilePurpose, ChargingProfileKindEnum chargingProfileKind, List<ChargingSchedule> chargingSchedule) {
        this.id = id;
        this.stackLevel = stackLevel;
        this.chargingProfilePurpose = chargingProfilePurpose;
        this.chargingProfileKind = chargingProfileKind;
        this.chargingSchedule = chargingSchedule;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public ChargingProfile withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    public ChargingProfile withId(Integer id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="stackLevel")
    public Integer getStackLevel() {
        return this.stackLevel;
    }

    @JsonProperty(value="stackLevel")
    public void setStackLevel(Integer stackLevel) {
        this.stackLevel = stackLevel;
    }

    public ChargingProfile withStackLevel(Integer stackLevel) {
        this.stackLevel = stackLevel;
        return this;
    }

    @JsonProperty(value="chargingProfilePurpose")
    public ChargingProfilePurposeEnum getChargingProfilePurpose() {
        return this.chargingProfilePurpose;
    }

    @JsonProperty(value="chargingProfilePurpose")
    public void setChargingProfilePurpose(ChargingProfilePurposeEnum chargingProfilePurpose) {
        this.chargingProfilePurpose = chargingProfilePurpose;
    }

    public ChargingProfile withChargingProfilePurpose(ChargingProfilePurposeEnum chargingProfilePurpose) {
        this.chargingProfilePurpose = chargingProfilePurpose;
        return this;
    }

    @JsonProperty(value="chargingProfileKind")
    public ChargingProfileKindEnum getChargingProfileKind() {
        return this.chargingProfileKind;
    }

    @JsonProperty(value="chargingProfileKind")
    public void setChargingProfileKind(ChargingProfileKindEnum chargingProfileKind) {
        this.chargingProfileKind = chargingProfileKind;
    }

    public ChargingProfile withChargingProfileKind(ChargingProfileKindEnum chargingProfileKind) {
        this.chargingProfileKind = chargingProfileKind;
        return this;
    }

    @JsonProperty(value="recurrencyKind")
    public RecurrencyKindEnum getRecurrencyKind() {
        return this.recurrencyKind;
    }

    @JsonProperty(value="recurrencyKind")
    public void setRecurrencyKind(RecurrencyKindEnum recurrencyKind) {
        this.recurrencyKind = recurrencyKind;
    }

    public ChargingProfile withRecurrencyKind(RecurrencyKindEnum recurrencyKind) {
        this.recurrencyKind = recurrencyKind;
        return this;
    }

    @JsonProperty(value="validFrom")
    public Instant getValidFrom() {
        return this.validFrom;
    }

    @JsonProperty(value="validFrom")
    public void setValidFrom(Instant validFrom) {
        this.validFrom = validFrom;
    }

    public ChargingProfile withValidFrom(Instant validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    @JsonProperty(value="validTo")
    public Instant getValidTo() {
        return this.validTo;
    }

    @JsonProperty(value="validTo")
    public void setValidTo(Instant validTo) {
        this.validTo = validTo;
    }

    public ChargingProfile withValidTo(Instant validTo) {
        this.validTo = validTo;
        return this;
    }

    @JsonProperty(value="chargingSchedule")
    public List<ChargingSchedule> getChargingSchedule() {
        return this.chargingSchedule;
    }

    @JsonProperty(value="chargingSchedule")
    public void setChargingSchedule(List<ChargingSchedule> chargingSchedule) {
        this.chargingSchedule = chargingSchedule;
    }

    public ChargingProfile withChargingSchedule(List<ChargingSchedule> chargingSchedule) {
        this.chargingSchedule = chargingSchedule;
        return this;
    }

    @JsonProperty(value="transactionId")
    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="transactionId")
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public ChargingProfile withTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ChargingProfile.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("stackLevel");
        sb.append('=');
        sb.append(this.stackLevel == null ? "<null>" : this.stackLevel);
        sb.append(',');
        sb.append("chargingProfilePurpose");
        sb.append('=');
        sb.append(this.chargingProfilePurpose == null ? "<null>" : this.chargingProfilePurpose);
        sb.append(',');
        sb.append("chargingProfileKind");
        sb.append('=');
        sb.append(this.chargingProfileKind == null ? "<null>" : this.chargingProfileKind);
        sb.append(',');
        sb.append("recurrencyKind");
        sb.append('=');
        sb.append(this.recurrencyKind == null ? "<null>" : this.recurrencyKind);
        sb.append(',');
        sb.append("validFrom");
        sb.append('=');
        sb.append(this.validFrom == null ? "<null>" : this.validFrom);
        sb.append(',');
        sb.append("validTo");
        sb.append('=');
        sb.append(this.validTo == null ? "<null>" : this.validTo);
        sb.append(',');
        sb.append("chargingSchedule");
        sb.append('=');
        sb.append(this.chargingSchedule == null ? "<null>" : this.chargingSchedule);
        sb.append(',');
        sb.append("transactionId");
        sb.append('=');
        sb.append(this.transactionId == null ? "<null>" : this.transactionId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.chargingProfileKind == null ? 0 : this.chargingProfileKind.hashCode());
        result = result * 31 + (this.chargingProfilePurpose == null ? 0 : this.chargingProfilePurpose.hashCode());
        result = result * 31 + (this.recurrencyKind == null ? 0 : this.recurrencyKind.hashCode());
        result = result * 31 + (this.chargingSchedule == null ? 0 : this.chargingSchedule.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.validFrom == null ? 0 : this.validFrom.hashCode());
        result = result * 31 + (this.stackLevel == null ? 0 : this.stackLevel.hashCode());
        result = result * 31 + (this.transactionId == null ? 0 : this.transactionId.hashCode());
        result = result * 31 + (this.validTo == null ? 0 : this.validTo.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ChargingProfile)) {
            return false;
        }
        ChargingProfile rhs = (ChargingProfile)other;
        return (this.chargingProfileKind == rhs.chargingProfileKind || this.chargingProfileKind != null && this.chargingProfileKind.equals((Object)rhs.chargingProfileKind)) && (this.chargingProfilePurpose == rhs.chargingProfilePurpose || this.chargingProfilePurpose != null && this.chargingProfilePurpose.equals((Object)rhs.chargingProfilePurpose)) && (this.recurrencyKind == rhs.recurrencyKind || this.recurrencyKind != null && this.recurrencyKind.equals((Object)rhs.recurrencyKind)) && (this.chargingSchedule == rhs.chargingSchedule || this.chargingSchedule != null && this.chargingSchedule.equals(rhs.chargingSchedule)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.validFrom == rhs.validFrom || this.validFrom != null && this.validFrom.equals(rhs.validFrom)) && (this.stackLevel == rhs.stackLevel || this.stackLevel != null && this.stackLevel.equals(rhs.stackLevel)) && (this.transactionId == rhs.transactionId || this.transactionId != null && this.transactionId.equals(rhs.transactionId)) && (this.validTo == rhs.validTo || this.validTo != null && this.validTo.equals(rhs.validTo));
    }
}

