/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import ocpp.v201.ChargingRateUnitEnum;
import ocpp.v201.ChargingSchedulePeriod;
import ocpp.v201.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "chargingSchedulePeriod", "evseId", "duration", "scheduleStart", "chargingRateUnit"})
public class CompositeSchedule
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="chargingSchedulePeriod")
    private List<ChargingSchedulePeriod> chargingSchedulePeriod;
    @JsonProperty(value="evseId")
    @JsonPropertyDescription(value="The ID of the EVSE for which the\r\nschedule is requested. When evseid=0, the\r\nCharging Station calculated the expected\r\nconsumption for the grid connection.\r\n")
    private Integer evseId;
    @JsonProperty(value="duration")
    @JsonPropertyDescription(value="Duration of the schedule in seconds.\r\n")
    private Integer duration;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="scheduleStart")
    @JsonPropertyDescription(value="Composite_ Schedule. Start. Date_ Time\r\nurn:x-oca:ocpp:uid:1:569456\r\nDate and time at which the schedule becomes active. All time measurements within the schedule are relative to this timestamp.\r\n")
    private Instant scheduleStart;
    @JsonProperty(value="chargingRateUnit")
    @JsonPropertyDescription(value="The unit of measure Limit is\r\nexpressed in.\r\n")
    private ChargingRateUnitEnum chargingRateUnit;
    private static final long serialVersionUID = -1421833088988017398L;

    public CompositeSchedule() {
    }

    public CompositeSchedule(List<ChargingSchedulePeriod> chargingSchedulePeriod, Integer evseId, Integer duration, Instant scheduleStart, ChargingRateUnitEnum chargingRateUnit) {
        this.chargingSchedulePeriod = chargingSchedulePeriod;
        this.evseId = evseId;
        this.duration = duration;
        this.scheduleStart = scheduleStart;
        this.chargingRateUnit = chargingRateUnit;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public CompositeSchedule withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="chargingSchedulePeriod")
    public List<ChargingSchedulePeriod> getChargingSchedulePeriod() {
        return this.chargingSchedulePeriod;
    }

    @JsonProperty(value="chargingSchedulePeriod")
    public void setChargingSchedulePeriod(List<ChargingSchedulePeriod> chargingSchedulePeriod) {
        this.chargingSchedulePeriod = chargingSchedulePeriod;
    }

    public CompositeSchedule withChargingSchedulePeriod(List<ChargingSchedulePeriod> chargingSchedulePeriod) {
        this.chargingSchedulePeriod = chargingSchedulePeriod;
        return this;
    }

    @JsonProperty(value="evseId")
    public Integer getEvseId() {
        return this.evseId;
    }

    @JsonProperty(value="evseId")
    public void setEvseId(Integer evseId) {
        this.evseId = evseId;
    }

    public CompositeSchedule withEvseId(Integer evseId) {
        this.evseId = evseId;
        return this;
    }

    @JsonProperty(value="duration")
    public Integer getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public CompositeSchedule withDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @JsonProperty(value="scheduleStart")
    public Instant getScheduleStart() {
        return this.scheduleStart;
    }

    @JsonProperty(value="scheduleStart")
    public void setScheduleStart(Instant scheduleStart) {
        this.scheduleStart = scheduleStart;
    }

    public CompositeSchedule withScheduleStart(Instant scheduleStart) {
        this.scheduleStart = scheduleStart;
        return this;
    }

    @JsonProperty(value="chargingRateUnit")
    public ChargingRateUnitEnum getChargingRateUnit() {
        return this.chargingRateUnit;
    }

    @JsonProperty(value="chargingRateUnit")
    public void setChargingRateUnit(ChargingRateUnitEnum chargingRateUnit) {
        this.chargingRateUnit = chargingRateUnit;
    }

    public CompositeSchedule withChargingRateUnit(ChargingRateUnitEnum chargingRateUnit) {
        this.chargingRateUnit = chargingRateUnit;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(CompositeSchedule.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("chargingSchedulePeriod");
        sb.append('=');
        sb.append(this.chargingSchedulePeriod == null ? "<null>" : this.chargingSchedulePeriod);
        sb.append(',');
        sb.append("evseId");
        sb.append('=');
        sb.append(this.evseId == null ? "<null>" : this.evseId);
        sb.append(',');
        sb.append("duration");
        sb.append('=');
        sb.append(this.duration == null ? "<null>" : this.duration);
        sb.append(',');
        sb.append("scheduleStart");
        sb.append('=');
        sb.append(this.scheduleStart == null ? "<null>" : this.scheduleStart);
        sb.append(',');
        sb.append("chargingRateUnit");
        sb.append('=');
        sb.append(this.chargingRateUnit == null ? "<null>" : this.chargingRateUnit);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.evseId == null ? 0 : this.evseId.hashCode());
        result = result * 31 + (this.duration == null ? 0 : this.duration.hashCode());
        result = result * 31 + (this.scheduleStart == null ? 0 : this.scheduleStart.hashCode());
        result = result * 31 + (this.chargingSchedulePeriod == null ? 0 : this.chargingSchedulePeriod.hashCode());
        result = result * 31 + (this.chargingRateUnit == null ? 0 : this.chargingRateUnit.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CompositeSchedule)) {
            return false;
        }
        CompositeSchedule rhs = (CompositeSchedule)other;
        return (this.evseId == rhs.evseId || this.evseId != null && this.evseId.equals(rhs.evseId)) && (this.duration == rhs.duration || this.duration != null && this.duration.equals(rhs.duration)) && (this.scheduleStart == rhs.scheduleStart || this.scheduleStart != null && this.scheduleStart.equals(rhs.scheduleStart)) && (this.chargingSchedulePeriod == rhs.chargingSchedulePeriod || this.chargingSchedulePeriod != null && this.chargingSchedulePeriod.equals(rhs.chargingSchedulePeriod)) && (this.chargingRateUnit == rhs.chargingRateUnit || this.chargingRateUnit != null && this.chargingRateUnit.equals((Object)rhs.chargingRateUnit)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData));
    }
}

