/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ConnectorStatusEnum {
    AVAILABLE("Available"),
    OCCUPIED("Occupied"),
    RESERVED("Reserved"),
    UNAVAILABLE("Unavailable"),
    FAULTED("Faulted");

    private final String value;
    private static final Map<String, ConnectorStatusEnum> CONSTANTS;

    private ConnectorStatusEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ConnectorStatusEnum fromValue(String value) {
        ConnectorStatusEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ConnectorStatusEnum>();
        for (ConnectorStatusEnum c : ConnectorStatusEnum.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

