/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import ocpp.v201.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "messageId", "data", "vendorId"})
public class DataTransferRequest
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="messageId")
    @JsonPropertyDescription(value="May be used to indicate a specific message or implementation.\r\n")
    private String messageId;
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="Data without specified length or format. This needs to be decided by both parties (Open to implementation).\r\n")
    private Object data;
    @JsonProperty(value="vendorId")
    @JsonPropertyDescription(value="This identifies the Vendor specific implementation\r\n\r\n")
    private String vendorId;
    private static final long serialVersionUID = -6934167051454973690L;

    public DataTransferRequest() {
    }

    public DataTransferRequest(String vendorId) {
        this.vendorId = vendorId;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public DataTransferRequest withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    @JsonProperty(value="messageId")
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public DataTransferRequest withMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @JsonProperty(value="data")
    public Object getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(Object data) {
        this.data = data;
    }

    public DataTransferRequest withData(Object data) {
        this.data = data;
        return this;
    }

    @JsonProperty(value="vendorId")
    public String getVendorId() {
        return this.vendorId;
    }

    @JsonProperty(value="vendorId")
    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    public DataTransferRequest withVendorId(String vendorId) {
        this.vendorId = vendorId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DataTransferRequest.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("messageId");
        sb.append('=');
        sb.append(this.messageId == null ? "<null>" : this.messageId);
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(this.data == null ? "<null>" : this.data);
        sb.append(',');
        sb.append("vendorId");
        sb.append('=');
        sb.append(this.vendorId == null ? "<null>" : this.vendorId);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.messageId == null ? 0 : this.messageId.hashCode());
        result = result * 31 + (this.vendorId == null ? 0 : this.vendorId.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DataTransferRequest)) {
            return false;
        }
        DataTransferRequest rhs = (DataTransferRequest)other;
        return (this.messageId == rhs.messageId || this.messageId != null && this.messageId.equals(rhs.messageId)) && (this.vendorId == rhs.vendorId || this.vendorId != null && this.vendorId.equals(rhs.vendorId)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.data == rhs.data || this.data != null && this.data.equals(rhs.data));
    }
}

