/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;
import ocpp.v201.Component;
import ocpp.v201.CustomData;
import ocpp.v201.EventNotificationEnum;
import ocpp.v201.EventTriggerEnum;
import ocpp.v201.Variable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "eventId", "timestamp", "trigger", "cause", "actualValue", "techCode", "techInfo", "cleared", "transactionId", "component", "variableMonitoringId", "eventNotificationType", "variable"})
public class EventData
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="eventId")
    @JsonPropertyDescription(value="Identifies the event. This field can be referred to as a cause by other events.\r\n\r\n")
    private Integer eventId;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="timestamp")
    @JsonPropertyDescription(value="Timestamp of the moment the report was generated.\r\n")
    private Instant timestamp;
    @JsonProperty(value="trigger")
    @JsonPropertyDescription(value="Type of monitor that triggered this event, e.g. exceeding a threshold value.\r\n\r\n")
    private EventTriggerEnum trigger;
    @JsonProperty(value="cause")
    @JsonPropertyDescription(value="Refers to the Id of an event that is considered to be the cause for this event.\r\n\r\n")
    private Integer cause;
    @JsonProperty(value="actualValue")
    @JsonPropertyDescription(value="Actual value (_attributeType_ Actual) of the variable.\r\n\r\nThe Configuration Variable &lt;&lt;configkey-reporting-value-size,ReportingValueSize&gt;&gt; can be used to limit GetVariableResult.attributeValue, VariableAttribute.value and EventData.actualValue. The max size of these values will always remain equal. \r\n\r\n")
    private String actualValue;
    @JsonProperty(value="techCode")
    @JsonPropertyDescription(value="Technical (error) code as reported by component.\r\n")
    private String techCode;
    @JsonProperty(value="techInfo")
    @JsonPropertyDescription(value="Technical detail information as reported by component.\r\n")
    private String techInfo;
    @JsonProperty(value="cleared")
    @JsonPropertyDescription(value="_Cleared_ is set to true to report the clearing of a monitored situation, i.e. a 'return to normal'. \r\n\r\n")
    private Boolean cleared;
    @JsonProperty(value="transactionId")
    @JsonPropertyDescription(value="If an event notification is linked to a specific transaction, this field can be used to specify its transactionId.\r\n")
    private String transactionId;
    @JsonProperty(value="component")
    @JsonPropertyDescription(value="A physical or logical component\r\n")
    private Component component;
    @JsonProperty(value="variableMonitoringId")
    @JsonPropertyDescription(value="Identifies the VariableMonitoring which triggered the event.\r\n")
    private Integer variableMonitoringId;
    @JsonProperty(value="eventNotificationType")
    @JsonPropertyDescription(value="Specifies the event notification type of the message.\r\n\r\n")
    private EventNotificationEnum eventNotificationType;
    @JsonProperty(value="variable")
    @JsonPropertyDescription(value="Reference key to a component-variable.\r\n")
    private Variable variable;
    private static final long serialVersionUID = -3892207720819000635L;

    public EventData() {
    }

    public EventData(Integer eventId, Instant timestamp, EventTriggerEnum trigger, String actualValue, Component component, EventNotificationEnum eventNotificationType, Variable variable) {
        this.eventId = eventId;
        this.timestamp = timestamp;
        this.trigger = trigger;
        this.actualValue = actualValue;
        this.component = component;
        this.eventNotificationType = eventNotificationType;
        this.variable = variable;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public EventData withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="eventId")
    public Integer getEventId() {
        return this.eventId;
    }

    @JsonProperty(value="eventId")
    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public EventData withEventId(Integer eventId) {
        this.eventId = eventId;
        return this;
    }

    @JsonProperty(value="timestamp")
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public EventData withTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="trigger")
    public EventTriggerEnum getTrigger() {
        return this.trigger;
    }

    @JsonProperty(value="trigger")
    public void setTrigger(EventTriggerEnum trigger) {
        this.trigger = trigger;
    }

    public EventData withTrigger(EventTriggerEnum trigger) {
        this.trigger = trigger;
        return this;
    }

    @JsonProperty(value="cause")
    public Integer getCause() {
        return this.cause;
    }

    @JsonProperty(value="cause")
    public void setCause(Integer cause) {
        this.cause = cause;
    }

    public EventData withCause(Integer cause) {
        this.cause = cause;
        return this;
    }

    @JsonProperty(value="actualValue")
    public String getActualValue() {
        return this.actualValue;
    }

    @JsonProperty(value="actualValue")
    public void setActualValue(String actualValue) {
        this.actualValue = actualValue;
    }

    public EventData withActualValue(String actualValue) {
        this.actualValue = actualValue;
        return this;
    }

    @JsonProperty(value="techCode")
    public String getTechCode() {
        return this.techCode;
    }

    @JsonProperty(value="techCode")
    public void setTechCode(String techCode) {
        this.techCode = techCode;
    }

    public EventData withTechCode(String techCode) {
        this.techCode = techCode;
        return this;
    }

    @JsonProperty(value="techInfo")
    public String getTechInfo() {
        return this.techInfo;
    }

    @JsonProperty(value="techInfo")
    public void setTechInfo(String techInfo) {
        this.techInfo = techInfo;
    }

    public EventData withTechInfo(String techInfo) {
        this.techInfo = techInfo;
        return this;
    }

    @JsonProperty(value="cleared")
    public Boolean getCleared() {
        return this.cleared;
    }

    @JsonProperty(value="cleared")
    public void setCleared(Boolean cleared) {
        this.cleared = cleared;
    }

    public EventData withCleared(Boolean cleared) {
        this.cleared = cleared;
        return this;
    }

    @JsonProperty(value="transactionId")
    public String getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty(value="transactionId")
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public EventData withTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @JsonProperty(value="component")
    public Component getComponent() {
        return this.component;
    }

    @JsonProperty(value="component")
    public void setComponent(Component component) {
        this.component = component;
    }

    public EventData withComponent(Component component) {
        this.component = component;
        return this;
    }

    @JsonProperty(value="variableMonitoringId")
    public Integer getVariableMonitoringId() {
        return this.variableMonitoringId;
    }

    @JsonProperty(value="variableMonitoringId")
    public void setVariableMonitoringId(Integer variableMonitoringId) {
        this.variableMonitoringId = variableMonitoringId;
    }

    public EventData withVariableMonitoringId(Integer variableMonitoringId) {
        this.variableMonitoringId = variableMonitoringId;
        return this;
    }

    @JsonProperty(value="eventNotificationType")
    public EventNotificationEnum getEventNotificationType() {
        return this.eventNotificationType;
    }

    @JsonProperty(value="eventNotificationType")
    public void setEventNotificationType(EventNotificationEnum eventNotificationType) {
        this.eventNotificationType = eventNotificationType;
    }

    public EventData withEventNotificationType(EventNotificationEnum eventNotificationType) {
        this.eventNotificationType = eventNotificationType;
        return this;
    }

    @JsonProperty(value="variable")
    public Variable getVariable() {
        return this.variable;
    }

    @JsonProperty(value="variable")
    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public EventData withVariable(Variable variable) {
        this.variable = variable;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(EventData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("eventId");
        sb.append('=');
        sb.append(this.eventId == null ? "<null>" : this.eventId);
        sb.append(',');
        sb.append("timestamp");
        sb.append('=');
        sb.append(this.timestamp == null ? "<null>" : this.timestamp);
        sb.append(',');
        sb.append("trigger");
        sb.append('=');
        sb.append(this.trigger == null ? "<null>" : this.trigger);
        sb.append(',');
        sb.append("cause");
        sb.append('=');
        sb.append(this.cause == null ? "<null>" : this.cause);
        sb.append(',');
        sb.append("actualValue");
        sb.append('=');
        sb.append(this.actualValue == null ? "<null>" : this.actualValue);
        sb.append(',');
        sb.append("techCode");
        sb.append('=');
        sb.append(this.techCode == null ? "<null>" : this.techCode);
        sb.append(',');
        sb.append("techInfo");
        sb.append('=');
        sb.append(this.techInfo == null ? "<null>" : this.techInfo);
        sb.append(',');
        sb.append("cleared");
        sb.append('=');
        sb.append(this.cleared == null ? "<null>" : this.cleared);
        sb.append(',');
        sb.append("transactionId");
        sb.append('=');
        sb.append(this.transactionId == null ? "<null>" : this.transactionId);
        sb.append(',');
        sb.append("component");
        sb.append('=');
        sb.append(this.component == null ? "<null>" : this.component);
        sb.append(',');
        sb.append("variableMonitoringId");
        sb.append('=');
        sb.append(this.variableMonitoringId == null ? "<null>" : this.variableMonitoringId);
        sb.append(',');
        sb.append("eventNotificationType");
        sb.append('=');
        sb.append(this.eventNotificationType == null ? "<null>" : this.eventNotificationType);
        sb.append(',');
        sb.append("variable");
        sb.append('=');
        sb.append(this.variable == null ? "<null>" : this.variable);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.eventId == null ? 0 : this.eventId.hashCode());
        result = result * 31 + (this.techCode == null ? 0 : this.techCode.hashCode());
        result = result * 31 + (this.actualValue == null ? 0 : this.actualValue.hashCode());
        result = result * 31 + (this.cause == null ? 0 : this.cause.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.trigger == null ? 0 : this.trigger.hashCode());
        result = result * 31 + (this.techInfo == null ? 0 : this.techInfo.hashCode());
        result = result * 31 + (this.transactionId == null ? 0 : this.transactionId.hashCode());
        result = result * 31 + (this.component == null ? 0 : this.component.hashCode());
        result = result * 31 + (this.variableMonitoringId == null ? 0 : this.variableMonitoringId.hashCode());
        result = result * 31 + (this.variable == null ? 0 : this.variable.hashCode());
        result = result * 31 + (this.eventNotificationType == null ? 0 : this.eventNotificationType.hashCode());
        result = result * 31 + (this.cleared == null ? 0 : this.cleared.hashCode());
        result = result * 31 + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof EventData)) {
            return false;
        }
        EventData rhs = (EventData)other;
        return (this.eventId == rhs.eventId || this.eventId != null && this.eventId.equals(rhs.eventId)) && (this.techCode == rhs.techCode || this.techCode != null && this.techCode.equals(rhs.techCode)) && (this.actualValue == rhs.actualValue || this.actualValue != null && this.actualValue.equals(rhs.actualValue)) && (this.cause == rhs.cause || this.cause != null && this.cause.equals(rhs.cause)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.trigger == rhs.trigger || this.trigger != null && this.trigger.equals((Object)rhs.trigger)) && (this.techInfo == rhs.techInfo || this.techInfo != null && this.techInfo.equals(rhs.techInfo)) && (this.transactionId == rhs.transactionId || this.transactionId != null && this.transactionId.equals(rhs.transactionId)) && (this.component == rhs.component || this.component != null && this.component.equals(rhs.component)) && (this.variableMonitoringId == rhs.variableMonitoringId || this.variableMonitoringId != null && this.variableMonitoringId.equals(rhs.variableMonitoringId)) && (this.variable == rhs.variable || this.variable != null && this.variable.equals(rhs.variable)) && (this.eventNotificationType == rhs.eventNotificationType || this.eventNotificationType != null && this.eventNotificationType.equals((Object)rhs.eventNotificationType)) && (this.cleared == rhs.cleared || this.cleared != null && this.cleared.equals(rhs.cleared)) && (this.timestamp == rhs.timestamp || this.timestamp != null && this.timestamp.equals(rhs.timestamp));
    }
}

