/*
 * Decompiled with CFR 0.152.
 */
package ocpp.v201;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;
import ocpp.v201.CustomData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"customData", "location", "retrieveDateTime", "installDateTime", "signingCertificate", "signature"})
public class Firmware
implements Serializable {
    @JsonProperty(value="customData")
    @JsonPropertyDescription(value="This class does not get 'AdditionalProperties = false' in the schema generation, so it can be extended with arbitrary JSON properties to allow adding custom data.")
    private CustomData customData;
    @JsonProperty(value="location")
    @JsonPropertyDescription(value="Firmware. Location. URI\r\nurn:x-enexis:ecdm:uid:1:569460\r\nURI defining the origin of the firmware.\r\n")
    private String location;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="retrieveDateTime")
    @JsonPropertyDescription(value="Firmware. Retrieve. Date_ Time\r\nurn:x-enexis:ecdm:uid:1:569461\r\nDate and time at which the firmware shall be retrieved.\r\n")
    private Instant retrieveDateTime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss[.SSS]XXX", timezone="UTC")
    @JsonProperty(value="installDateTime")
    @JsonPropertyDescription(value="Firmware. Install. Date_ Time\r\nurn:x-enexis:ecdm:uid:1:569462\r\nDate and time at which the firmware shall be installed.\r\n")
    private Instant installDateTime;
    @JsonProperty(value="signingCertificate")
    @JsonPropertyDescription(value="Certificate with which the firmware was signed.\r\nPEM encoded X.509 certificate.\r\n")
    private String signingCertificate;
    @JsonProperty(value="signature")
    @JsonPropertyDescription(value="Firmware. Signature. Signature\r\nurn:x-enexis:ecdm:uid:1:569464\r\nBase64 encoded firmware signature.\r\n")
    private String signature;
    private static final long serialVersionUID = -5378777296025747015L;

    public Firmware() {
    }

    public Firmware(String location, Instant retrieveDateTime) {
        this.location = location;
        this.retrieveDateTime = retrieveDateTime;
    }

    @JsonProperty(value="customData")
    public CustomData getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(CustomData customData) {
        this.customData = customData;
    }

    public Firmware withCustomData(CustomData customData) {
        this.customData = customData;
        return this;
    }

    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    public void setLocation(String location) {
        this.location = location;
    }

    public Firmware withLocation(String location) {
        this.location = location;
        return this;
    }

    @JsonProperty(value="retrieveDateTime")
    public Instant getRetrieveDateTime() {
        return this.retrieveDateTime;
    }

    @JsonProperty(value="retrieveDateTime")
    public void setRetrieveDateTime(Instant retrieveDateTime) {
        this.retrieveDateTime = retrieveDateTime;
    }

    public Firmware withRetrieveDateTime(Instant retrieveDateTime) {
        this.retrieveDateTime = retrieveDateTime;
        return this;
    }

    @JsonProperty(value="installDateTime")
    public Instant getInstallDateTime() {
        return this.installDateTime;
    }

    @JsonProperty(value="installDateTime")
    public void setInstallDateTime(Instant installDateTime) {
        this.installDateTime = installDateTime;
    }

    public Firmware withInstallDateTime(Instant installDateTime) {
        this.installDateTime = installDateTime;
        return this;
    }

    @JsonProperty(value="signingCertificate")
    public String getSigningCertificate() {
        return this.signingCertificate;
    }

    @JsonProperty(value="signingCertificate")
    public void setSigningCertificate(String signingCertificate) {
        this.signingCertificate = signingCertificate;
    }

    public Firmware withSigningCertificate(String signingCertificate) {
        this.signingCertificate = signingCertificate;
        return this;
    }

    @JsonProperty(value="signature")
    public String getSignature() {
        return this.signature;
    }

    @JsonProperty(value="signature")
    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Firmware withSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Firmware.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("customData");
        sb.append('=');
        sb.append(this.customData == null ? "<null>" : this.customData);
        sb.append(',');
        sb.append("location");
        sb.append('=');
        sb.append(this.location == null ? "<null>" : this.location);
        sb.append(',');
        sb.append("retrieveDateTime");
        sb.append('=');
        sb.append(this.retrieveDateTime == null ? "<null>" : this.retrieveDateTime);
        sb.append(',');
        sb.append("installDateTime");
        sb.append('=');
        sb.append(this.installDateTime == null ? "<null>" : this.installDateTime);
        sb.append(',');
        sb.append("signingCertificate");
        sb.append('=');
        sb.append(this.signingCertificate == null ? "<null>" : this.signingCertificate);
        sb.append(',');
        sb.append("signature");
        sb.append('=');
        sb.append(this.signature == null ? "<null>" : this.signature);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.signingCertificate == null ? 0 : this.signingCertificate.hashCode());
        result = result * 31 + (this.retrieveDateTime == null ? 0 : this.retrieveDateTime.hashCode());
        result = result * 31 + (this.signature == null ? 0 : this.signature.hashCode());
        result = result * 31 + (this.customData == null ? 0 : this.customData.hashCode());
        result = result * 31 + (this.location == null ? 0 : this.location.hashCode());
        result = result * 31 + (this.installDateTime == null ? 0 : this.installDateTime.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Firmware)) {
            return false;
        }
        Firmware rhs = (Firmware)other;
        return (this.signingCertificate == rhs.signingCertificate || this.signingCertificate != null && this.signingCertificate.equals(rhs.signingCertificate)) && (this.retrieveDateTime == rhs.retrieveDateTime || this.retrieveDateTime != null && this.retrieveDateTime.equals(rhs.retrieveDateTime)) && (this.signature == rhs.signature || this.signature != null && this.signature.equals(rhs.signature)) && (this.customData == rhs.customData || this.customData != null && this.customData.equals(rhs.customData)) && (this.location == rhs.location || this.location != null && this.location.equals(rhs.location)) && (this.installDateTime == rhs.installDateTime || this.installDateTime != null && this.installDateTime.equals(rhs.installDateTime));
    }
}

